/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.richclient.application.ApplicationServices;
import org.springframework.richclient.util.Assert;

public class StaticApplicationServices
implements ApplicationServices {
    private final Map services = Collections.synchronizedMap(new HashMap());

    public Object getService(Class serviceType) {
        Assert.required(serviceType, "serviceType");
        Object service = this.services.get(serviceType);
        if (service == null) {
            throw new UnsupportedOperationException("No service of type '" + serviceType + "' found.");
        }
        return service;
    }

    public boolean containsService(Class serviceType) {
        Assert.required(serviceType, "serviceType");
        return this.services.containsKey(serviceType);
    }

    public void registerService(Object service, Class serviceInterface) {
        Assert.required(service, "service");
        Assert.required(serviceInterface, "serviceInterface");
        this.services.put(serviceInterface, service);
    }
}

