/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.application.PageLayoutBuilder;
import org.springframework.richclient.application.support.AbstractApplicationPage;
import org.springframework.richclient.util.PopupMenuMouseListener;

public class TabbedApplicationPage
extends AbstractApplicationPage
implements PageLayoutBuilder {
    private JTabbedPane tabbedPane;
    private int tabPlacement = -1;
    private int tabLayoutPolicy = -1;
    private boolean addingComponent;

    protected JComponent createControl() {
        this.tabbedPane = new JTabbedPane();
        if (this.tabPlacement != -1) {
            this.tabbedPane.setTabPlacement(this.tabPlacement);
        }
        if (this.tabLayoutPolicy != -1) {
            this.tabbedPane.setTabLayoutPolicy(this.tabLayoutPolicy);
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!TabbedApplicationPage.this.addingComponent && TabbedApplicationPage.this.tabbedPane.getSelectedIndex() >= 0) {
                    TabbedApplicationPage.this.setActiveComponent(TabbedApplicationPage.this.getComponent(TabbedApplicationPage.this.tabbedPane.getSelectedIndex()));
                }
            }
        });
        JPopupMenu popup = new JPopupMenu();
        JMenuItem close = new JMenuItem("Close");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabbedApplicationPage.this.close(TabbedApplicationPage.this.getComponent(TabbedApplicationPage.this.tabbedPane.getSelectedIndex()));
            }
        });
        popup.add(close);
        this.tabbedPane.addMouseListener(new PopupMenuMouseListener(popup));
        this.getPageDescriptor().buildInitialLayout(this);
        return this.tabbedPane;
    }

    protected void updatePageComponentProperties(PageComponent pageComponent) {
        int index = this.indexOf(pageComponent);
        this.tabbedPane.setIconAt(index, pageComponent.getIcon());
        this.tabbedPane.setTitleAt(index, pageComponent.getDisplayName());
        this.tabbedPane.setToolTipTextAt(index, pageComponent.getCaption());
    }

    public void addView(String viewDescriptorId) {
        this.showView(viewDescriptorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAddPageComponent(PageComponent pageComponent) {
        try {
            this.addingComponent = true;
            this.tabbedPane.addTab(pageComponent.getDisplayName(), pageComponent.getIcon(), pageComponent.getContext().getPane().getControl(), pageComponent.getCaption());
        }
        finally {
            this.addingComponent = false;
        }
    }

    protected void doRemovePageComponent(PageComponent pageComponent) {
        this.tabbedPane.removeTabAt(this.indexOf(pageComponent));
    }

    protected boolean giveFocusTo(PageComponent pageComponent) {
        int componentIndex = this.indexOf(pageComponent);
        if (componentIndex < 0) {
            return false;
        }
        this.tabbedPane.setSelectedIndex(componentIndex);
        return true;
    }

    private int indexOf(PageComponent component) {
        return this.getPageComponents().indexOf(component);
    }

    private PageComponent getComponent(int index) {
        return this.getPageComponents().get(index);
    }

    public void setTabPlacement(int tabPlacement) {
        this.tabPlacement = tabPlacement;
    }

    public void setTabLayoutPolicy(int tabLayoutPolicy) {
        this.tabLayoutPolicy = tabLayoutPolicy;
    }
}

