/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommandExecutor;
import org.springframework.richclient.command.ActionCommandInterceptor;
import org.springframework.richclient.command.ParameterizableActionCommandExecutor;
import org.springframework.richclient.command.SwingActionAdapter;
import org.springframework.richclient.command.config.CommandFaceDescriptor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class ActionCommand
extends AbstractCommand
implements ActionCommandExecutor,
ParameterizableActionCommandExecutor {
    public static final String ACTION_COMMAND_PROPERTY = "actionCommand";
    public static final String ACTION_COMMAND_PARAMETER_KEY = "actionCommand";
    public static final String ACTION_EVENT_PARAMETER_KEY = "actionEvent";
    public static final String MODIFIERS_PARAMETER_KEY = "modifiers";
    private static final String ELLIPSES = "...";
    private List<ActionCommandInterceptor> commandInterceptors;
    private String actionCommand;
    private SwingActionAdapter swingActionAdapter;
    private Map<Object, Object> parameters = new HashMap<Object, Object>(6);
    private boolean displaysInputDialog;
    ActionListener actionPerformedHandler = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ActionCommand.this.addParameter(ActionCommand.ACTION_EVENT_PARAMETER_KEY, e);
            ActionCommand.this.addParameter(ActionCommand.MODIFIERS_PARAMETER_KEY, e.getModifiers());
            ActionCommand.this.addParameter("actionCommand", ActionCommand.this);
            ActionCommand.this.execute();
        }
    };

    public ActionCommand() {
    }

    public ActionCommand(String commandId) {
        super(commandId);
    }

    public ActionCommand(String id, CommandFaceDescriptor face) {
        super(id, face);
    }

    public ActionCommand(String id, String encodedLabel) {
        super(id, encodedLabel);
    }

    public ActionCommand(String id, String encodedLabel, Icon icon, String caption) {
        super(id, encodedLabel, icon, caption);
    }

    public void addParameter(Object key, Object value) {
        this.parameters.put(key, value);
    }

    protected Object getParameter(Object key) {
        return this.parameters.get(key);
    }

    protected Map getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    protected Object getParameter(Object key, Object defaultValue) {
        Object value = this.parameters.get(key);
        return value != null ? value : defaultValue;
    }

    public void addCommandInterceptor(ActionCommandInterceptor l) {
        if (this.commandInterceptors == null) {
            this.commandInterceptors = new ArrayList<ActionCommandInterceptor>(6);
        }
        this.commandInterceptors.add(l);
    }

    public void removeCommandInterceptor(ActionCommandInterceptor l) {
        Assert.notNull(this.commandInterceptors, (String)"The command interceptors list has not yet been initialized");
        this.commandInterceptors.remove(l);
    }

    protected void onButtonAttached(AbstractButton button) {
        super.onButtonAttached(button);
        button.setActionCommand(this.actionCommand);
        button.addActionListener(this.actionPerformedHandler);
        if (this.displaysInputDialog && button.getText() != null && !button.getText().endsWith(ELLIPSES)) {
            button.setText(this.getText() + ELLIPSES);
        }
    }

    protected int getModifiers() {
        return (Integer)this.getParameter(MODIFIERS_PARAMETER_KEY, 0);
    }

    public Action getActionAdapter() {
        if (this.swingActionAdapter == null) {
            this.swingActionAdapter = new SwingActionAdapter(this);
        }
        return this.swingActionAdapter;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String newCommandName) {
        if (!ObjectUtils.nullSafeEquals((Object)this.actionCommand, (Object)newCommandName)) {
            String old = this.actionCommand;
            this.actionCommand = newCommandName;
            Iterator iter = this.buttonIterator();
            while (iter.hasNext()) {
                AbstractButton button = (AbstractButton)iter.next();
                button.setActionCommand(this.actionCommand);
            }
            this.firePropertyChange("actionCommand", old, newCommandName);
        }
    }

    public void setDefaultButtonIn(RootPaneContainer container) {
        JRootPane rootPane = container.getRootPane();
        JButton button = (JButton)this.getButtonIn(rootPane);
        if (button != null) {
            rootPane.setDefaultButton(button);
        }
    }

    public void setDefaultButton() {
        Iterator it = this.buttonIterator();
        while (it.hasNext()) {
            JButton button;
            JRootPane pane;
            Object o = it.next();
            if (!(o instanceof JButton) || (pane = SwingUtilities.getRootPane(button = (JButton)o)) == null) continue;
            pane.setDefaultButton(button);
        }
    }

    public void setDisplaysInputDialog(boolean displaysInputDialog) {
        this.displaysInputDialog = displaysInputDialog;
    }

    public boolean isDisplaysInputDialog() {
        return this.displaysInputDialog;
    }

    public final void execute(Map parameters) {
        this.parameters.putAll(parameters);
        this.execute();
    }

    public final void execute() {
        if (this.onPreExecute()) {
            this.doExecuteCommand();
            this.onPostExecute();
        }
        this.parameters.clear();
    }

    protected final boolean onPreExecute() {
        if (this.commandInterceptors == null) {
            return true;
        }
        for (ActionCommandInterceptor commandInterceptor : this.commandInterceptors) {
            ActionCommandInterceptor listener = commandInterceptor;
            if (listener.preExecution(this)) continue;
            return false;
        }
        return true;
    }

    protected abstract void doExecuteCommand();

    protected final void onPostExecute() {
        if (this.commandInterceptors == null) {
            return;
        }
        Iterator<ActionCommandInterceptor> i$ = this.commandInterceptors.iterator();
        while (i$.hasNext()) {
            ActionCommandInterceptor commandInterceptor;
            ActionCommandInterceptor interceptor = commandInterceptor = i$.next();
            interceptor.postExecution(this);
        }
    }

    protected boolean isShiftDown() {
        return (this.getModifiers() & 1) != 0;
    }

    protected boolean isControlDown() {
        return (this.getModifiers() & 2) != 0;
    }

    protected boolean isMetaDown() {
        return (this.getModifiers() & 4) != 0;
    }

    protected boolean isAltDown() {
        return (this.getModifiers() & 8) != 0;
    }
}

