/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.richclient.command.GroupContainerPopulator;
import org.springframework.richclient.command.GroupMember;
import org.springframework.richclient.command.config.CommandButtonConfigurer;
import org.springframework.richclient.util.Assert;

public class ExpansionPointGroupMember
extends GroupMember {
    private static final String DEFAULT_EXPANSION_POINT_NAME = "default";
    private final HashSet members = new LinkedHashSet(5);
    private final String expansionPointName;
    private boolean leadingSeparator;
    private boolean endingSeparator;

    protected ExpansionPointGroupMember() {
        this.expansionPointName = DEFAULT_EXPANSION_POINT_NAME;
    }

    protected ExpansionPointGroupMember(String expansionPointName) {
        Assert.required(expansionPointName, "expansionPointName");
        this.expansionPointName = expansionPointName;
    }

    public boolean isLeadingSeparator() {
        return this.leadingSeparator;
    }

    public void setLeadingSeparator(boolean leadingSeparator) {
        this.leadingSeparator = leadingSeparator;
    }

    public boolean isEndingSeparator() {
        return this.endingSeparator;
    }

    public void setEndingSeparator(boolean endingSeparator) {
        this.endingSeparator = endingSeparator;
    }

    public String getExpansionPointName() {
        return this.expansionPointName;
    }

    protected void add(GroupMember member) {
        Assert.required(member, "member");
        if (this.members.add(member)) {
            member.onAdded();
        }
    }

    public void remove(GroupMember member) {
        if (this.members.remove(member)) {
            member.onRemoved();
        }
    }

    protected void clear() {
        this.members.clear();
    }

    protected void fill(GroupContainerPopulator containerPopulator, Object controlFactory, CommandButtonConfigurer configurer, List previousButtons) {
        Assert.required(containerPopulator, "containerPopulator");
        Assert.required(controlFactory, "controlFactory");
        Assert.required(configurer, "configurer");
        if (this.members.size() > 0 && this.isLeadingSeparator()) {
            containerPopulator.addSeparator();
        }
        for (GroupMember member : this.members) {
            member.fill(containerPopulator, controlFactory, configurer, previousButtons);
        }
        if (this.members.size() > 0 && this.isEndingSeparator()) {
            containerPopulator.addSeparator();
        }
    }

    public GroupMember getMemberFor(String commandId) {
        for (GroupMember member : this.members) {
            if (!member.managesCommand(commandId)) continue;
            return member;
        }
        return null;
    }

    public boolean managesCommand(String commandId) {
        for (GroupMember member : this.members) {
            if (!member.managesCommand(commandId)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public void setEnabled(boolean enabled) {
    }
}

