/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import java.util.List;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.command.CommandRegistry;
import org.springframework.richclient.command.GroupContainerPopulator;
import org.springframework.richclient.command.GroupMember;
import org.springframework.richclient.command.SimpleGroupMember;
import org.springframework.richclient.command.config.CommandButtonConfigurer;
import org.springframework.richclient.util.Assert;

public class LazyGroupMember
extends GroupMember {
    private final CommandGroup parentGroup;
    private final String lazyCommandId;
    private boolean addedLazily;
    private GroupMember loadedMember;

    public LazyGroupMember(CommandGroup parentGroup, String lazyCommandId) {
        Assert.required(parentGroup, "parentGroup");
        Assert.required(lazyCommandId, "lazyCommandId");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Lazy group member '" + lazyCommandId + "' instantiated for group '" + parentGroup.getId() + "'"));
        }
        this.parentGroup = parentGroup;
        this.lazyCommandId = lazyCommandId;
    }

    public void setEnabled(boolean enabled) {
        if (this.loadedMember != null) {
            this.loadedMember.setEnabled(enabled);
        }
    }

    protected void fill(GroupContainerPopulator parentContainerPopulator, Object controlFactory, CommandButtonConfigurer buttonConfigurer, List previousButtons) {
        this.loadIfNecessary();
        if (this.loadedMember != null) {
            this.loadedMember.fill(parentContainerPopulator, controlFactory, buttonConfigurer, previousButtons);
        }
    }

    private void loadIfNecessary() {
        if (this.loadedMember != null) {
            return;
        }
        CommandRegistry commandRegistry = this.parentGroup.getCommandRegistry();
        Assert.isTrue((this.parentGroup.getCommandRegistry() != null ? 1 : 0) != 0, (String)("Command registry must be set for group '" + this.parentGroup.getId() + "' in order to load lazy command '" + this.lazyCommandId + "'."));
        if (commandRegistry.containsCommandGroup(this.lazyCommandId)) {
            CommandGroup group = commandRegistry.getCommandGroup(this.lazyCommandId);
            this.loadedMember = new SimpleGroupMember(this.parentGroup, group);
        } else if (commandRegistry.containsActionCommand(this.lazyCommandId)) {
            ActionCommand command = commandRegistry.getActionCommand(this.lazyCommandId);
            this.loadedMember = new SimpleGroupMember(this.parentGroup, command);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Lazy command '" + this.lazyCommandId + "' was asked to display; however, no backing command instance exists in registry."));
        }
        if (this.addedLazily && this.loadedMember != null) {
            this.loadedMember.onAdded();
        }
    }

    public boolean managesCommand(String commandId) {
        return this.lazyCommandId.equals(commandId);
    }

    protected void onAdded() {
        if (this.loadedMember != null) {
            this.loadedMember.onAdded();
        } else {
            this.addedLazily = true;
        }
    }

    protected void onRemoved() {
        if (this.loadedMember != null) {
            this.loadedMember.onRemoved();
        } else {
            this.addedLazily = false;
        }
    }
}

