/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.command.ExclusiveCommandGroup;
import org.springframework.richclient.command.GroupContainerPopulator;
import org.springframework.richclient.command.GroupMember;
import org.springframework.richclient.command.InvalidGroupMemberException;
import org.springframework.richclient.command.ToggleCommand;
import org.springframework.richclient.command.config.CommandButtonConfigurer;
import org.springframework.richclient.factory.ButtonFactory;
import org.springframework.richclient.factory.MenuFactory;
import org.springframework.richclient.util.Assert;

public class SimpleGroupMember
extends GroupMember {
    private final CommandGroup parent;
    private final AbstractCommand command;

    public SimpleGroupMember(CommandGroup parentGroup, AbstractCommand command) {
        this.parent = parentGroup;
        this.command = command;
        if (!parentGroup.isAllowedMember(command)) {
            throw new InvalidGroupMemberException(command.getClass(), parentGroup.getClass());
        }
    }

    public void setEnabled(boolean enabled) {
        this.command.setEnabled(enabled);
    }

    protected void fill(GroupContainerPopulator containerPopulator, Object controlFactory, CommandButtonConfigurer buttonConfigurer, List previousButtons) {
        Assert.required(containerPopulator, "containerPopulator");
        Assert.required(buttonConfigurer, "buttonConfigurer");
        if (controlFactory instanceof MenuFactory) {
            JMenuItem menu = this.findMenu(this.command, previousButtons);
            if (menu == null) {
                menu = this.command.createMenuItem((MenuFactory)controlFactory, buttonConfigurer);
            }
            this.logger.debug((Object)"Adding menu item to container");
            containerPopulator.add(menu);
        } else if (controlFactory instanceof ButtonFactory) {
            AbstractButton button = this.findButton(this.command, previousButtons);
            if (button == null) {
                button = this.command.createButton((ButtonFactory)controlFactory, buttonConfigurer);
            }
            this.logger.debug((Object)"Adding button to container");
            containerPopulator.add(button);
        }
    }

    public boolean managesCommand(String commandId) {
        if (commandId == null) {
            return false;
        }
        return commandId.equals(this.command.getId());
    }

    public AbstractCommand getCommand() {
        return this.command;
    }

    protected JMenuItem findMenu(AbstractCommand attachedCommand, List abstractButtons) {
        if (abstractButtons == null) {
            return null;
        }
        Iterator it = abstractButtons.iterator();
        while (it.hasNext()) {
            AbstractButton button = (AbstractButton)it.next();
            if (!(button instanceof JMenuItem) || !attachedCommand.isAttached(button)) continue;
            it.remove();
            return (JMenuItem)button;
        }
        return null;
    }

    protected AbstractButton findButton(AbstractCommand attachedCommand, List buttons) {
        if (buttons == null) {
            return null;
        }
        Iterator it = buttons.iterator();
        while (it.hasNext()) {
            AbstractButton button = (AbstractButton)it.next();
            if (button instanceof JMenuItem || !attachedCommand.isAttached(button)) continue;
            it.remove();
            return button;
        }
        return null;
    }

    protected void onAdded() {
        if (this.parent instanceof ExclusiveCommandGroup) {
            ((ExclusiveCommandGroup)this.parent).getSelectionController().add((ToggleCommand)this.command);
        }
    }

    protected void onRemoved() {
        if (this.parent instanceof ExclusiveCommandGroup) {
            ((ExclusiveCommandGroup)this.parent).getSelectionController().remove((ToggleCommand)this.command);
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("command", (Object)this.command).toString();
    }
}

