/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.JSplitPane;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.config.CommandButtonConfigurer;
import org.springframework.richclient.command.config.CommandConfigurer;
import org.springframework.richclient.factory.ButtonFactory;

public class SplitPaneExpansionToggleCommand
extends ActionCommand {
    private DefaultButtonModel model;

    public SplitPaneExpansionToggleCommand(String commandId, JSplitPane splitPane, boolean switchedAway) {
        super(commandId);
        this.model = new SplitPaneExpansionButtonModel(splitPane, switchedAway);
        ((CommandConfigurer)Application.services().getService(CommandConfigurer.class)).configure(this);
    }

    protected void doExecuteCommand() {
        this.model.setSelected(!this.model.isSelected());
    }

    public void doHide() {
        this.model.setSelected(false);
    }

    public void doShow() {
        this.model.setSelected(true);
    }

    public AbstractButton createButton(String faceDescriptorId, ButtonFactory buttonFactory, CommandButtonConfigurer configurer) {
        AbstractButton button = buttonFactory.createToggleButton();
        this.attach(button, faceDescriptorId, configurer);
        return button;
    }

    public void attach(AbstractButton button, String faceDescriptorId, CommandButtonConfigurer configurer) {
        super.attach(button, faceDescriptorId, configurer);
        button.setModel(this.model);
    }

    public static class SplitPaneExpansionButtonModel
    extends DefaultButtonModel {
        private final JSplitPane splitPane;
        private SWITCH_STATE state = SWITCH_STATE.NO_ACTION;
        private transient PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                SplitPaneExpansionButtonModel.this.fireStateChanged();
                if (SplitPaneExpansionButtonModel.this.state == SWITCH_STATE.SWITCHED_AWAY) {
                    SplitPaneExpansionButtonModel.this.state = SWITCH_STATE.SWITCHED_AWAY_AND_MOVED;
                } else if (SplitPaneExpansionButtonModel.this.state == SWITCH_STATE.SWITCHED_AWAY_AND_MOVED) {
                    SplitPaneExpansionButtonModel.this.state = SWITCH_STATE.NO_ACTION;
                }
            }
        };

        public SplitPaneExpansionButtonModel(JSplitPane mySplitPane, boolean switchedAway) {
            this.splitPane = mySplitPane;
            this.splitPane.addPropertyChangeListener("dividerLocation", this.listener);
            this.splitPane.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    if (SplitPaneExpansionButtonModel.this.state == SWITCH_STATE.SWITCHED_AWAY || SplitPaneExpansionButtonModel.this.state == SWITCH_STATE.SWITCHED_AWAY_AND_MOVED) {
                        SplitPaneExpansionButtonModel.this.hidePanel();
                    }
                }
            });
            if (switchedAway) {
                this.state = SWITCH_STATE.SWITCHED_AWAY;
            }
        }

        public boolean isSelected() {
            return this.isShown();
        }

        public void setSelected(boolean makeVisible) {
            super.setSelected(makeVisible);
            if (makeVisible) {
                this.splitPane.resetToPreferredSizes();
                this.state = SWITCH_STATE.NO_ACTION;
            } else {
                this.hidePanel();
            }
        }

        private void hidePanel() {
            this.splitPane.setDividerLocation(this.getHideRightComponentDividerLocation());
            this.state = SWITCH_STATE.SWITCHED_AWAY;
        }

        private boolean isShown() {
            return this.splitPane.getDividerLocation() < this.getHideRightComponentDividerLocation();
        }

        private int getHideRightComponentDividerLocation() {
            Dimension size = this.splitPane.getSize();
            int max = this.getRelevantDimensionpart(size);
            Insets insets = this.splitPane.getInsets();
            int relevantInset = this.getRelevantInsetpart(insets);
            int dividerSize = this.splitPane.getDividerSize();
            return max - (relevantInset + dividerSize);
        }

        private int getRelevantInsetpart(Insets insets) {
            int orientation = this.splitPane.getOrientation();
            int result = orientation == 0 ? insets.bottom : insets.right;
            return result;
        }

        private int getRelevantDimensionpart(Dimension size) {
            int orientation = this.splitPane.getOrientation();
            int result = orientation == 0 ? (int)Math.ceil(size.getHeight()) : (int)Math.ceil(size.getWidth());
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum SWITCH_STATE {
            NO_ACTION,
            SWITCHED_AWAY,
            SWITCHED_AWAY_AND_MOVED;

        }
    }
}

