/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.ActionCommandExecutor;
import org.springframework.richclient.command.GuardedActionCommandExecutor;
import org.springframework.richclient.command.ParameterizableActionCommandExecutor;
import org.springframework.util.ObjectUtils;

public class TargetableActionCommand
extends ActionCommand {
    private ActionCommandExecutor commandExecutor;
    private PropertyChangeListener guardRelay;

    public TargetableActionCommand() {
        this(null);
    }

    public TargetableActionCommand(String commandId) {
        this(commandId, (ActionCommandExecutor)null);
    }

    public TargetableActionCommand(String commandId, ActionCommandExecutor commandExecutor) {
        super(commandId);
        this.setEnabled(false);
        this.setCommandExecutor(commandExecutor);
    }

    public void setCommandExecutor(ActionCommandExecutor commandExecutor) {
        if (ObjectUtils.nullSafeEquals((Object)this.commandExecutor, (Object)commandExecutor)) {
            return;
        }
        if (commandExecutor == null) {
            this.detachCommandExecutor();
        } else {
            if (this.commandExecutor instanceof GuardedActionCommandExecutor) {
                this.unsubscribeFromGuardedCommandDelegate();
            }
            this.commandExecutor = commandExecutor;
            this.attachCommandExecutor();
        }
    }

    private void attachCommandExecutor() {
        if (this.commandExecutor instanceof GuardedActionCommandExecutor) {
            GuardedActionCommandExecutor dynamicHandler = (GuardedActionCommandExecutor)this.commandExecutor;
            this.setEnabled(dynamicHandler.isEnabled());
            this.subscribeToGuardedCommandDelegate();
        } else {
            this.setEnabled(true);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Command executor '" + this.commandExecutor + "' attached."));
        }
    }

    private void subscribeToGuardedCommandDelegate() {
        this.guardRelay = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TargetableActionCommand.this.setEnabled(((GuardedActionCommandExecutor)TargetableActionCommand.this.commandExecutor).isEnabled());
            }
        };
        ((GuardedActionCommandExecutor)this.commandExecutor).addEnabledListener(this.guardRelay);
    }

    public void detachCommandExecutor() {
        if (this.commandExecutor instanceof GuardedActionCommandExecutor) {
            this.unsubscribeFromGuardedCommandDelegate();
        }
        this.commandExecutor = null;
        this.setEnabled(false);
        this.logger.debug((Object)"Command delegate detached.");
    }

    private void unsubscribeFromGuardedCommandDelegate() {
        ((GuardedActionCommandExecutor)this.commandExecutor).removeEnabledListener(this.guardRelay);
    }

    protected void doExecuteCommand() {
        if (this.commandExecutor instanceof ParameterizableActionCommandExecutor) {
            ((ParameterizableActionCommandExecutor)this.commandExecutor).execute(this.getParameters());
        } else if (this.commandExecutor != null) {
            this.commandExecutor.execute();
        }
    }
}

