/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.config;

import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.core.LabelInfo;
import org.springframework.richclient.factory.ButtonConfigurer;
import org.springframework.richclient.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class CommandButtonLabelInfo
implements ButtonConfigurer {
    public static final CommandButtonLabelInfo BLANK_BUTTON_LABEL = new CommandButtonLabelInfo("");
    private final LabelInfo labelInfo;
    private final KeyStroke accelerator;

    public static CommandButtonLabelInfo valueOf(String labelDescriptor) {
        if (!StringUtils.hasText((String)labelDescriptor)) {
            return BLANK_BUTTON_LABEL;
        }
        StringBuffer labelInfoBuffer = new StringBuffer();
        KeyStroke keyStroke = null;
        int i = 0;
        int textCharsIndex = 0;
        while (i < labelDescriptor.length()) {
            char currentChar = labelDescriptor.charAt(i);
            if (currentChar == '\\') {
                int nextCharIndex = i + 1;
                if (nextCharIndex < labelDescriptor.length()) {
                    char nextChar = labelDescriptor.charAt(nextCharIndex);
                    if (nextChar == '@') {
                        labelInfoBuffer.append(nextChar);
                        ++i;
                    } else {
                        labelInfoBuffer.append(currentChar);
                        labelInfoBuffer.append(nextChar);
                        ++i;
                    }
                }
            } else {
                if (currentChar == '@') {
                    if (i + 1 == labelDescriptor.length()) {
                        throw new IllegalArgumentException("The label descriptor [" + labelDescriptor + "] does not specify a valid accelerator after the last " + "non-espaced @ symbol.");
                    }
                    String acceleratorStr = labelDescriptor.substring(i + 1);
                    keyStroke = KeyStroke.getKeyStroke(acceleratorStr);
                    if (keyStroke != null) break;
                    throw new IllegalArgumentException("The keystroke accelerator string [" + acceleratorStr + "] from the label descriptor [" + labelDescriptor + "] is not a valid keystroke format.");
                }
                labelInfoBuffer.append(currentChar);
            }
            ++i;
            ++textCharsIndex;
        }
        LabelInfo info = LabelInfo.valueOf(labelInfoBuffer.toString());
        return new CommandButtonLabelInfo(info, keyStroke);
    }

    public CommandButtonLabelInfo(String text) {
        this(new LabelInfo(text), null);
    }

    public CommandButtonLabelInfo(LabelInfo labelInfo, KeyStroke accelerator) {
        Assert.required(labelInfo, "labelInfo");
        this.labelInfo = labelInfo;
        this.accelerator = accelerator;
    }

    public String getText() {
        return this.labelInfo.getText();
    }

    public int getMnemonic() {
        return this.labelInfo.getMnemonic();
    }

    public int getMnemonicIndex() {
        return this.labelInfo.getMnemonicIndex();
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public int hashCode() {
        return this.labelInfo.hashCode() + (this.accelerator != null ? this.accelerator.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CommandButtonLabelInfo)) {
            return false;
        }
        CommandButtonLabelInfo other = (CommandButtonLabelInfo)obj;
        if (!this.labelInfo.equals(other.labelInfo)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.accelerator, (Object)other.accelerator);
    }

    public AbstractButton configure(AbstractButton button) {
        Assert.notNull((Object)button);
        button.setText(this.labelInfo.getText());
        button.setMnemonic(this.labelInfo.getMnemonic());
        button.setDisplayedMnemonicIndex(this.labelInfo.getMnemonicIndex());
        this.configureAccelerator(button, this.getAccelerator());
        return button;
    }

    protected void configureAccelerator(AbstractButton button, KeyStroke keystrokeAccelerator) {
        if (button instanceof JMenuItem && !(button instanceof JMenu)) {
            ((JMenuItem)button).setAccelerator(keystrokeAccelerator);
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("labelInfo", (Object)this.labelInfo).append("accelerator", (Object)this.accelerator).toString();
    }
}

