/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.config;

import java.awt.Insets;
import javax.swing.AbstractButton;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.config.CommandFaceDescriptor;
import org.springframework.richclient.command.config.DefaultCommandButtonConfigurer;
import org.springframework.richclient.image.ShadowedIcon;

public class ToolBarCommandButtonConfigurer
extends DefaultCommandButtonConfigurer {
    private boolean showText = false;
    private boolean textBelowIcon = true;
    private boolean enableShadow = false;

    public boolean isEnableShadow() {
        return this.enableShadow;
    }

    public void setEnableShadow(boolean enableShadow) {
        this.enableShadow = enableShadow;
    }

    public void setTextBelowIcon(boolean textBelowIcon) {
        this.textBelowIcon = textBelowIcon;
    }

    public boolean isTextBelowIcon() {
        return this.textBelowIcon;
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void configure(AbstractButton button, AbstractCommand command, CommandFaceDescriptor faceDescriptor) {
        super.configure(button, command, faceDescriptor);
        if (this.textBelowIcon) {
            button.setHorizontalTextPosition(0);
            button.setVerticalTextPosition(3);
        }
        if (!this.showText && button.getIcon() != null) {
            button.setText(null);
        }
        if (this.enableShadow && button.getIcon() != null && button.getRolloverIcon() == null) {
            button.setRolloverEnabled(true);
            button.setRolloverIcon(new ShadowedIcon(button.getIcon()));
        }
        button.setMargin(new Insets(2, 5, 2, 5));
    }
}

