/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.support;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.springframework.richclient.command.support.SimpleGroupContainerPopulator;

public class ButtonBarGroupContainerPopulator
extends SimpleGroupContainerPopulator {
    private ColumnSpec columnSpec;
    private ButtonBarBuilder builder;
    private List buttons = new ArrayList();

    public ButtonBarGroupContainerPopulator() {
        super(new JPanel());
        this.builder = new ButtonBarBuilder((JPanel)this.getContainer());
    }

    public void setMinimumButtonSize(Size minimumSize) {
        this.columnSpec = new ColumnSpec(minimumSize);
    }

    public void setColumnSpec(ColumnSpec columnSpec) {
        this.columnSpec = columnSpec;
    }

    public void setRowSpec(RowSpec rowSpec) {
        if (rowSpec != null) {
            this.builder.getLayout().setRowSpec(1, rowSpec);
        }
    }

    public JPanel getButtonBar() {
        return this.builder.getPanel();
    }

    public void add(Component c) {
        this.buttons.add(c);
    }

    public void addSeparator() {
        this.buttons.add("separator");
    }

    public void onPopulated() {
        this.builder.addGlue();
        int length = this.buttons.size();
        for (int i = 0; i < length; ++i) {
            Object o = this.buttons.get(i);
            if (o instanceof String && o == "separator") {
                this.builder.addUnrelatedGap();
                continue;
            }
            if (!(o instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)o;
            if (this.columnSpec != null) {
                this.addCustomGridded(button);
            } else {
                this.builder.addGridded((JComponent)button);
            }
            if (i >= this.buttons.size() - 1) continue;
            this.builder.addRelatedGap();
        }
    }

    private void addCustomGridded(AbstractButton button) {
        this.builder.getLayout().appendColumn(this.columnSpec);
        this.builder.getLayout().addGroupedColumn(this.builder.getColumn());
        button.putClientProperty("jgoodies.isNarrow", Boolean.TRUE);
        this.builder.add((Component)button);
        this.builder.nextColumn();
    }
}

