/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.support;

import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.springframework.richclient.command.support.SimpleGroupContainerPopulator;

public class ButtonStackGroupContainerPopulator
extends SimpleGroupContainerPopulator {
    private RowSpec rowSpec;
    private ButtonStackBuilder builder;
    private List buttons = new ArrayList();

    public ButtonStackGroupContainerPopulator() {
        super(new JPanel());
        this.builder = new ButtonStackBuilder((JPanel)this.getContainer());
    }

    public void setMinimumButtonSize(Size minimumSize) {
        this.rowSpec = new RowSpec(minimumSize);
    }

    public void setRowSpec(RowSpec rowSpec) {
        this.rowSpec = rowSpec;
    }

    public void setColumnSpec(ColumnSpec columnSpec) {
        if (columnSpec != null) {
            this.builder.getLayout().setColumnSpec(1, columnSpec);
        }
    }

    public JPanel getButtonStack() {
        return this.builder.getPanel();
    }

    public void add(Component c) {
        this.buttons.add(c);
    }

    public void addSeparator() {
        this.buttons.add("separator");
    }

    public void onPopulated() {
        int length = this.buttons.size();
        for (int i = 0; i < length; ++i) {
            Object o = this.buttons.get(i);
            if (o instanceof String && o == "separator") {
                this.builder.addUnrelatedGap();
                continue;
            }
            if (!(o instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)o;
            if (this.rowSpec != null) {
                this.addCustomGridded(button);
            } else {
                this.builder.addGridded((JComponent)button);
            }
            if (i >= this.buttons.size() - 1) continue;
            this.builder.addRelatedGap();
        }
        this.builder.addGlue();
    }

    private void addCustomGridded(AbstractButton button) {
        this.builder.getLayout().appendRow(this.rowSpec);
        this.builder.getLayout().addGroupedRow(this.builder.getRow());
        button.putClientProperty("jgoodies.isNarrow", Boolean.TRUE);
        this.builder.add((Component)button);
        this.builder.nextRow();
    }
}

