/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.components;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.components.UserInputListener;
import org.springframework.util.Assert;

public class BigDecimalTextField
extends JTextField {
    private static final long serialVersionUID = -601376040393562990L;
    Log log = LogFactory.getLog(BigDecimalTextField.class);
    public static final NumberFormat DEFAULT_FORMAT = new DecimalFormat("###,###,###,##0.######");
    public static final NumberFormat DEFAULT_UNFORMAT = new DecimalFormat("#0.#######");
    public static final DecimalFormatSymbols symbols = new DecimalFormatSymbols();
    private Class numberClass = null;
    private final NumberFormat format;
    private final NumberFormat unformat;
    private Integer scale;
    private List listeners;
    private boolean internallySettingText = false;

    public BigDecimalTextField() {
        this(2, 4, true);
    }

    public BigDecimalTextField(int nrOfNonDecimals, int nrOfDecimals, boolean negativeSign) {
        this(nrOfNonDecimals, nrOfDecimals, negativeSign, BigDecimal.class);
    }

    public BigDecimalTextField(int nrOfNonDecimals, int nrOfDecimals, boolean negativeSign, Class numberClass) {
        this(nrOfNonDecimals, nrOfDecimals, negativeSign, numberClass, DEFAULT_FORMAT);
    }

    public BigDecimalTextField(int nrOfNonDecimals, int nrOfDecimals, boolean negativeSign, Class numberClass, NumberFormat format) {
        this(nrOfNonDecimals, nrOfDecimals, negativeSign, numberClass, format, DEFAULT_UNFORMAT);
    }

    public BigDecimalTextField(int nrOfNonDecimals, int nrOfDecimals, boolean negativeSign, Class numberClass, NumberFormat format, NumberFormat unformat) {
        Assert.notNull((Object)format);
        Assert.notNull((Object)unformat);
        this.format = format;
        BigDecimalTextField.setBigDecimalFormat(format, numberClass);
        this.unformat = unformat;
        BigDecimalTextField.setBigDecimalFormat(unformat, numberClass);
        this.numberClass = numberClass;
        this.setDocument(new BigDecimalDocument(nrOfNonDecimals, nrOfDecimals, negativeSign));
        this.addFocusListener(new FormatFocusListener());
    }

    private static final void setBigDecimalFormat(NumberFormat format, Class numberClass) {
        if (format instanceof DecimalFormat && (numberClass == BigDecimal.class || numberClass == BigInteger.class)) {
            ((DecimalFormat)format).setParseBigDecimal(true);
        }
    }

    public void addUserInputListener(UserInputListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeUserInputListener(UserInputListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireUserInputChange() {
        if (!this.internallySettingText && this.listeners != null) {
            for (UserInputListener userInputListener : this.listeners) {
                userInputListener.update(this);
            }
        }
    }

    public Number getValue() {
        if (this.getText() == null || "".equals(this.getText().trim())) {
            return null;
        }
        try {
            Number n = this.format.parse(this.getText());
            if (n.getClass() == this.numberClass) {
                return n;
            }
            if (this.numberClass == BigDecimal.class) {
                BigDecimal bd = new BigDecimal(n.doubleValue());
                if (this.scale != null) {
                    bd = bd.setScale((int)this.scale, 4);
                }
                return bd;
            }
            if (this.numberClass == Double.class) {
                return new Double(n.doubleValue());
            }
            if (this.numberClass == Float.class) {
                return new Float(n.floatValue());
            }
            if (this.numberClass == BigInteger.class) {
                return ((BigDecimal)n).toBigInteger();
            }
            if (this.numberClass == Long.class) {
                return new Long(n.longValue());
            }
            if (this.numberClass == Integer.class) {
                return new Integer(n.intValue());
            }
            if (this.numberClass == Short.class) {
                return new Short(n.shortValue());
            }
            if (this.numberClass == Byte.class) {
                return new Byte(n.byteValue());
            }
            return null;
        }
        catch (Exception pe) {
            this.log.error((Object)("Error:  " + this.getText() + " is not a number."), (Throwable)pe);
            return null;
        }
    }

    public void setValue(Number number) {
        String txt = null;
        if (number != null) {
            txt = this.format.format(number);
        }
        this.setText(txt);
    }

    private void setTextInternally(String s) {
        this.internallySettingText = true;
        this.setText(s);
        this.internallySettingText = false;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    class BigDecimalDocument
    extends PlainDocument {
        private final int nrOfNonDecimals;
        private final int nrOfDecimals;
        private final boolean negativeSign;
        private final char decimalSeparator = symbols.getDecimalSeparator();
        private final char alternativeSeparator;

        public BigDecimalDocument() {
            this(10, 2, true);
        }

        public BigDecimalDocument(int nrOfNonDecimals, int nrOfDecimals, boolean negativeSign) {
            this(nrOfNonDecimals, nrOfDecimals, negativeSign, symbols.getGroupingSeparator());
        }

        public BigDecimalDocument(int nrOfNonDecimals, int nrOfDecimals, boolean negativeSign, char alternativeSeparator) {
            this.nrOfNonDecimals = nrOfNonDecimals;
            this.nrOfDecimals = nrOfDecimals;
            this.negativeSign = negativeSign;
            this.alternativeSeparator = alternativeSeparator;
        }

        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            boolean isNegative;
            if ("-".equals(str)) {
                if (this.negativeSign) {
                    if (this.getLength() == 0 || !this.getText(0, 1).equals("-")) {
                        super.insertString(0, str, a);
                    } else if (this.getLength() != 0 && this.getText(0, 1).equals("-")) {
                        super.remove(0, 1);
                    }
                    BigDecimalTextField.this.fireUserInputChange();
                }
                return;
            }
            if ("+".equals(str)) {
                if (this.negativeSign && this.getLength() != 0 && this.getText(0, 1).equals("-")) {
                    super.remove(0, 1);
                    BigDecimalTextField.this.fireUserInputChange();
                }
                return;
            }
            if (this.isShortCut(str)) {
                this.handleShortCut(str, offset, a);
                return;
            }
            if (str.length() == 1 && (this.alternativeSeparator == str.charAt(0) || this.decimalSeparator == str.charAt(0))) {
                if (this.nrOfDecimals > 0 && this.nrOfDecimals >= this.getLength() - offset && this.getText(0, this.getLength()).indexOf(this.decimalSeparator) == -1) {
                    super.insertString(offset, Character.toString(this.decimalSeparator), a);
                    BigDecimalTextField.this.fireUserInputChange();
                }
                return;
            }
            String s = this.getText(0, offset) + str;
            if (offset < this.getLength()) {
                s = s + this.getText(offset, this.getLength() - offset);
            }
            char[] sarr = (isNegative = s.startsWith("-")) ? s.substring(1).toCharArray() : s.toCharArray();
            int sep = -1;
            int numberLength = 0;
            for (int i = 0; i < sarr.length; ++i) {
                if (sarr[i] == this.decimalSeparator) {
                    if (sep != -1) {
                        BigDecimalTextField.this.log.warn((Object)("Error while inserting string: " + s + "[pos=" + i + "]" + " Double decimalseparator?"));
                        return;
                    }
                    sep = i;
                    if (numberLength > this.nrOfNonDecimals) {
                        BigDecimalTextField.this.log.warn((Object)("Error while inserting string: " + s + "[pos=" + i + "]" + " Too many non decimals? [" + this.nrOfNonDecimals + "]"));
                        return;
                    }
                    if (sarr.length - sep - 1 <= this.nrOfDecimals) continue;
                    BigDecimalTextField.this.log.warn((Object)("Error while inserting string: " + s + "[pos=" + i + "]" + " Too many decimals? [" + this.nrOfDecimals + "]"));
                    return;
                }
                if (sarr[i] == symbols.getGroupingSeparator()) continue;
                if (!Character.isDigit(sarr[i])) {
                    BigDecimalTextField.this.log.warn((Object)("Error while inserting string: " + s + "[pos=" + i + "]" + " String contains character that is no digit or separator?"));
                    return;
                }
                ++numberLength;
            }
            if (sep == -1 && numberLength > this.nrOfNonDecimals) {
                BigDecimalTextField.this.log.warn((Object)("Error while inserting string: " + s + " Too many non decimals? [" + this.nrOfNonDecimals + "]"));
                return;
            }
            super.insertString(offset, str, a);
            BigDecimalTextField.this.fireUserInputChange();
        }

        private void handleShortCut(String str, int offset, AttributeSet a) throws BadLocationException {
            BigDecimalTextField.this.log.debug((Object)("handing shortcut " + str));
            if (this.getLength() == 0) {
                if (str.equals("k")) {
                    super.insertString(0, "1000", a);
                } else if (str.equals("m")) {
                    super.insertString(0, "1000000", a);
                } else if (str.equals("b")) {
                    super.insertString(0, "1000000000", a);
                }
            } else if (this.getLength() != 1 || !this.getText(0, 1).equals("-") && !this.getText(0, 1).equals("+")) {
                String text = this.getText(0, offset);
                text = text.replace(',', '.');
                BigDecimal dec = new BigDecimal(text);
                if (str.equals("k")) {
                    dec = dec.scaleByPowerOfTen(3);
                } else if (str.equals("m")) {
                    dec = dec.scaleByPowerOfTen(6);
                } else if (str.equals("b")) {
                    dec = dec.scaleByPowerOfTen(9);
                }
                super.remove(0, offset);
                String outcome = dec.toBigIntegerExact().toString();
                outcome = outcome.replace('.', this.decimalSeparator);
                super.insertString(0, outcome, a);
                BigDecimalTextField.this.fireUserInputChange();
            }
        }

        private boolean isShortCut(String str) {
            return str.equals("k") || str.equals("m") || str.equals("b");
        }

        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            BigDecimalTextField.this.fireUserInputChange();
        }

        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            boolean oldInternallySettingText = BigDecimalTextField.this.internallySettingText;
            BigDecimalTextField.this.internallySettingText = true;
            super.replace(offset, length, text, attrs);
            BigDecimalTextField.this.internallySettingText = oldInternallySettingText;
            BigDecimalTextField.this.fireUserInputChange();
        }
    }

    class FormatFocusListener
    implements FocusListener {
        FormatFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            String s = BigDecimalTextField.this.getText();
            BigDecimalTextField.this.setTextInternally(this.format(BigDecimalTextField.this.unformat, BigDecimalTextField.this.format, s));
            BigDecimalTextField.this.selectAll();
        }

        public void focusLost(FocusEvent e) {
            String s = BigDecimalTextField.this.getText();
            BigDecimalTextField.this.setTextInternally(this.format(BigDecimalTextField.this.format, BigDecimalTextField.this.unformat, s));
        }

        private String format(NumberFormat toFormat, NumberFormat fromFormat, String s) {
            if (!"".equals(s)) {
                try {
                    return toFormat.format(fromFormat.parse(s));
                }
                catch (ParseException pe) {
                    BigDecimalTextField.this.log.error((Object)("Fout: De ingevulde waarde " + BigDecimalTextField.this.getText() + " is geen nummer."), (Throwable)pe);
                }
            }
            return null;
        }
    }
}

