/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.components;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.components.MessagableTab;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.image.IconSource;

public class MessagableTabbedPane
extends JTabbedPane
implements MessagableTab {
    private List<TabMessages> messages = new ArrayList<TabMessages>();
    private IconSource iconSource;
    private Icon oldIcon;
    private String oldToolTipText;

    public MessagableTabbedPane() {
    }

    public MessagableTabbedPane(int tabPlacement) {
        super(tabPlacement);
    }

    public MessagableTabbedPane(int tabPlacement, int tabPolicy) {
        super(tabPlacement, tabPolicy);
    }

    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        this.messages.add(index, new TabMessages());
    }

    private Icon getIcon(String severityLabel) {
        if (this.iconSource == null) {
            this.iconSource = (IconSource)ApplicationServicesLocator.services().getService(IconSource.class);
        }
        return this.iconSource.getIcon("severity." + severityLabel + ".overlay");
    }

    public void setMessage(Object source, Message message, int tabIndex) {
        TabMessages tabMessages = this.messages.get(tabIndex);
        if (tabMessages.put(source, message)) {
            if (tabMessages.hasErrors()) {
                if (this.oldIcon == null) {
                    this.oldIcon = this.getIconAt(tabIndex);
                }
                if (this.oldToolTipText == null) {
                    this.oldToolTipText = this.getToolTipTextAt(tabIndex);
                }
                if (this.oldIcon == this.getIcon(Severity.ERROR.getLabel())) {
                    this.oldIcon = null;
                    this.oldToolTipText = null;
                }
                this.setIconAt(tabIndex, this.getIcon(Severity.ERROR.getLabel()));
                this.setToolTipTextAt(tabIndex, tabMessages.getFirstMessage());
            } else {
                this.setIconAt(tabIndex, this.oldIcon);
                this.setToolTipTextAt(tabIndex, this.oldToolTipText);
                this.oldIcon = null;
                this.oldToolTipText = null;
            }
        }
    }

    private static class TabMessages {
        private int numberOfErrors = 0;
        private HashMap<Object, Message> messages = new HashMap();
        private Stack<Message> messageStack = new Stack();

        private TabMessages() {
        }

        public boolean put(Object key, Message message) {
            boolean firstErrorOrLessErrors = false;
            Message oldMessage = this.messages.get(key);
            if (oldMessage != message) {
                if (oldMessage == null || message == null || oldMessage.getSeverity() != message.getSeverity()) {
                    if (message != null && message.getSeverity() == Severity.ERROR) {
                        if (this.numberOfErrors == 0) {
                            firstErrorOrLessErrors = true;
                        }
                        ++this.numberOfErrors;
                        this.messageStack.add(message);
                    } else if (oldMessage != null && oldMessage.getSeverity() == Severity.ERROR) {
                        --this.numberOfErrors;
                        this.messageStack.remove(oldMessage);
                        firstErrorOrLessErrors = true;
                    }
                }
                if (message != null) {
                    this.messages.put(key, message);
                } else {
                    this.messages.remove(key);
                }
            }
            return firstErrorOrLessErrors;
        }

        public Message get(Object key) {
            return this.messages.get(key);
        }

        public int getNumberOfErrors() {
            return this.numberOfErrors;
        }

        public boolean hasErrors() {
            return this.numberOfErrors > 0;
        }

        public String getFirstMessage() {
            if (this.messageStack.size() > 0) {
                return ((Message)this.messageStack.firstElement()).getMessage();
            }
            return null;
        }
    }
}

