/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.components;

import javax.swing.JLabel;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.Guarded;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.image.IconSource;

public class MessageReportingOverlay
extends JLabel
implements Messagable,
Guarded {
    private IconSource iconSource;

    public IconSource getIconSource() {
        if (this.iconSource == null) {
            this.iconSource = (IconSource)ApplicationServicesLocator.services().getService(IconSource.class);
        }
        return this.iconSource;
    }

    public void setIconSource(IconSource iconSource) {
        this.iconSource = iconSource;
    }

    public boolean isEnabled() {
        return this.isVisible();
    }

    public void setEnabled(boolean enabled) {
        this.setVisible(enabled);
    }

    public void setMessage(Message message) {
        if (message == null) {
            message = DefaultMessage.EMPTY_MESSAGE;
        }
        this.setToolTipText(message.getMessage());
        Severity severity = message.getSeverity();
        if (severity != null) {
            this.setIcon(this.getIconSource().getIcon("severity." + severity.getLabel() + ".overlay"));
        } else {
            this.setIcon(null);
        }
    }
}

