/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.components;

import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipComponentsFocusTraversalPolicy
extends LayoutFocusTraversalPolicy {
    List<JComponent> componentsToSkip;
    public static final SkipComponentsFocusTraversalPolicy skipJTextComponentTraversalPolicy = new SkipComponentsFocusTraversalPolicy();

    public SkipComponentsFocusTraversalPolicy() {
    }

    public SkipComponentsFocusTraversalPolicy(List<JComponent> componentsToSkip) {
        this.componentsToSkip = componentsToSkip;
    }

    @Override
    protected boolean accept(Component aComponent) {
        if (!super.accept(aComponent)) {
            return false;
        }
        if (aComponent instanceof JTextComponent && !((JTextComponent)aComponent).isEditable()) {
            return false;
        }
        if (this.componentsToSkip != null) {
            for (JComponent component : this.componentsToSkip) {
                if (component != aComponent && !component.isAncestorOf(aComponent)) continue;
                return false;
            }
        }
        return true;
    }
}

