/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.application.support.ApplicationServicesAccessor;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.core.Guarded;
import org.springframework.richclient.core.TitleConfigurable;
import org.springframework.richclient.dialog.CloseAction;
import org.springframework.richclient.dialog.MessageDialog;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.richclient.util.WindowUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class ApplicationDialog
extends ApplicationServicesAccessor
implements TitleConfigurable,
Guarded {
    private static final String DEFAULT_DIALOG_TITLE = "Application Dialog";
    protected static final String DEFAULT_FINISH_COMMAND_ID = "okCommand";
    protected static final String DEFAULT_CANCEL_COMMAND_ID = "cancelCommand";
    protected static final String DEFAULT_FINISH_SUCCESS_MESSAGE_KEY = "defaultFinishSuccessMessage";
    protected static final String DEFAULT_FINISH_SUCCESS_TITLE_KEY = "defaultFinishSuccessTitle";
    protected static final String SUCCESS_FINISH_MESSAGE_KEY = "finishSuccessMessage";
    protected static final String SUCCESS_FINISH_TITLE_KEY = "finishSuccessTitle";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final DialogEventHandler dialogEventHandler = new DialogEventHandler();
    private String title;
    private JDialog dialog;
    private Component parentComponent;
    private Window parentWindow;
    private CloseAction closeAction = CloseAction.DISPOSE;
    private boolean defaultEnabled = true;
    private boolean modal = true;
    private boolean resizable = true;
    private Dimension preferredSize;
    private Point location;
    private Component locationRelativeTo;
    private ActionCommand finishCommand;
    private ActionCommand cancelCommand;
    private CommandGroup dialogCommandGroup;
    private boolean displayFinishSuccessMessage;
    private ActionCommand callingCommand;

    public ApplicationDialog() {
        this.init();
    }

    public ApplicationDialog(String title, Component parent) {
        this.setTitle(title);
        this.setParentComponent(parent);
        this.init();
    }

    public ApplicationDialog(String title, Component parent, CloseAction closeAction) {
        this.setTitle(title);
        this.setParentComponent(parent);
        this.setCloseAction(closeAction);
        this.init();
    }

    protected void init() {
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.dialog != null) {
            this.dialog.setTitle(this.getTitle());
        }
    }

    protected String getTitle() {
        if (!StringUtils.hasText((String)this.title)) {
            if (StringUtils.hasText((String)this.getCallingCommandText())) {
                return this.getCallingCommandText();
            }
            return DEFAULT_DIALOG_TITLE;
        }
        return this.title;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public Component getParentComponent() {
        return this.parentComponent;
    }

    public void setCloseAction(CloseAction action) {
        this.closeAction = action;
    }

    public void setDefaultEnabled(boolean enabled) {
        this.defaultEnabled = enabled;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public void setLocationRelativeTo(Component locationRelativeTo) {
        this.locationRelativeTo = locationRelativeTo;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public void setEnabled(boolean enabled) {
        this.setFinishEnabled(enabled);
    }

    public void setDisplayFinishSuccessMessage(boolean displayFinishSuccessMessage) {
        this.displayFinishSuccessMessage = displayFinishSuccessMessage;
    }

    public void setCallingCommand(ActionCommand callingCommand) {
        this.callingCommand = callingCommand;
    }

    protected void setFinishEnabled(boolean enabled) {
        if (this.isControlCreated()) {
            this.finishCommand.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        if (this.isControlCreated()) {
            return this.finishCommand.isEnabled();
        }
        return false;
    }

    public boolean isShowing() {
        if (!this.isControlCreated()) {
            return false;
        }
        return this.dialog.isShowing();
    }

    public boolean isControlCreated() {
        return this.dialog != null;
    }

    public JDialog getDialog() {
        if (!this.isControlCreated()) {
            this.createDialog();
        }
        return this.dialog;
    }

    protected Container getDialogContentPane() {
        Assert.state((boolean)this.isControlCreated(), (String)"The wrapped JDialog control has not yet been created.");
        return this.dialog.getContentPane();
    }

    public void showDialog() {
        if (!this.isControlCreated()) {
            this.createDialog();
        }
        if (!this.isShowing()) {
            this.onAboutToShow();
            if (this.getLocation() != null) {
                this.dialog.setLocation(this.getLocation());
                this.dialog.setPreferredSize(this.getPreferredSize());
            } else {
                WindowUtils.centerOnParent(this.dialog, this.getLocationRelativeTo());
            }
            this.dialog.setVisible(true);
        }
    }

    protected void componentsChanged() {
        if (this.isControlCreated()) {
            this.dialog.pack();
        }
    }

    protected final void createDialog() {
        this.constructDialog();
        this.addDialogComponents();
        this.attachListeners();
        this.registerDefaultCommand();
        this.onInitialized();
        this.dialog.pack();
    }

    private void constructDialog() {
        this.dialog = this.getParentWindow() instanceof Frame ? new JDialog((Frame)this.getParentWindow(), this.getTitle(), this.modal) : new JDialog((Dialog)this.getParentWindow(), this.getTitle(), this.modal);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.setResizable(this.resizable);
        this.initStandardCommands();
        this.addCancelByEscapeKey();
    }

    public static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return ApplicationDialog.getWindowForComponent(parentComponent.getParent());
    }

    private void initStandardCommands() {
        this.finishCommand = new ActionCommand(this.getFinishCommandId()){

            public void doExecuteCommand() {
                boolean result = ApplicationDialog.this.onFinish();
                if (result) {
                    if (ApplicationDialog.this.getDisplayFinishSuccessMessage()) {
                        ApplicationDialog.this.showFinishSuccessMessageDialog();
                    }
                    ApplicationDialog.this.executeCloseAction();
                }
            }
        };
        this.finishCommand.setSecurityControllerId(this.getFinishSecurityControllerId());
        this.finishCommand.setEnabled(this.defaultEnabled);
        this.cancelCommand = new ActionCommand(this.getCancelCommandId()){

            public void doExecuteCommand() {
                ApplicationDialog.this.onCancel();
            }
        };
    }

    protected String getFinishCommandId() {
        return DEFAULT_FINISH_COMMAND_ID;
    }

    protected String getFinishSecurityControllerId() {
        return null;
    }

    protected abstract boolean onFinish();

    protected boolean getDisplayFinishSuccessMessage() {
        return this.displayFinishSuccessMessage;
    }

    protected void showFinishSuccessMessageDialog() {
        MessageDialog messageDialog = new MessageDialog(this.getFinishSuccessTitle(), (Window)this.getDialog(), this.getFinishSuccessMessage());
        messageDialog.showDialog();
    }

    protected String getFinishSuccessMessage() {
        ActionCommand callingCommand = this.getCallingCommand();
        if (callingCommand != null) {
            String[] successMessageKeys = new String[]{callingCommand.getId() + "." + SUCCESS_FINISH_MESSAGE_KEY, DEFAULT_FINISH_SUCCESS_MESSAGE_KEY};
            return this.getMessage(successMessageKeys, this.getFinishSuccessMessageArguments());
        }
        return this.getMessage(DEFAULT_FINISH_SUCCESS_MESSAGE_KEY);
    }

    protected ActionCommand getCallingCommand() {
        return this.callingCommand;
    }

    protected Object[] getFinishSuccessMessageArguments() {
        return new Object[0];
    }

    protected String getFinishSuccessTitle() {
        ActionCommand callingCommand = this.getCallingCommand();
        if (callingCommand != null) {
            String[] successTitleKeys = new String[]{callingCommand.getId() + "." + SUCCESS_FINISH_TITLE_KEY, DEFAULT_FINISH_SUCCESS_TITLE_KEY};
            return this.getMessage(successTitleKeys, this.getFinishSuccessTitleArguments());
        }
        return this.getMessage(DEFAULT_FINISH_SUCCESS_TITLE_KEY);
    }

    protected Object[] getFinishSuccessTitleArguments() {
        if (StringUtils.hasText((String)this.getCallingCommandText())) {
            return new Object[]{this.getCallingCommandText()};
        }
        return new Object[0];
    }

    private String getCallingCommandText() {
        return this.getCallingCommand() != null ? this.getCallingCommand().getText() : null;
    }

    protected String getCancelCommandId() {
        return DEFAULT_CANCEL_COMMAND_ID;
    }

    protected ActionCommand getFinishCommand() {
        return this.finishCommand;
    }

    protected ActionCommand getCancelCommand() {
        return this.cancelCommand;
    }

    private void addCancelByEscapeKey() {
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        this.addActionKeyBinding(escapeKey, this.cancelCommand.getId());
    }

    protected void addActionKeyBinding(KeyStroke key, String actionKey) {
        if (actionKey == this.finishCommand.getId()) {
            this.addActionKeyBinding(key, actionKey, this.finishCommand.getActionAdapter());
        } else if (actionKey == this.cancelCommand.getId()) {
            this.addActionKeyBinding(key, actionKey, this.cancelCommand.getActionAdapter());
        } else {
            throw new IllegalArgumentException("Unknown action key " + actionKey);
        }
    }

    protected void addActionKeyBinding(KeyStroke key, String actionKey, Action action) {
        this.getInputMap().put(key, actionKey);
        this.getActionMap().put(actionKey, action);
    }

    protected ActionMap getActionMap() {
        return this.getDialog().getLayeredPane().getActionMap();
    }

    protected InputMap getInputMap() {
        return this.getDialog().getLayeredPane().getInputMap(1);
    }

    protected void addDialogComponents() {
        JComponent dialogContentPane = this.createDialogContentPane();
        GuiStandardUtils.attachDialogBorder(dialogContentPane);
        if (this.getPreferredSize() != null) {
            dialogContentPane.setPreferredSize(this.getPreferredSize());
        }
        this.getDialogContentPane().add(dialogContentPane);
        this.getDialogContentPane().add((Component)this.createButtonBar(), "South");
    }

    protected Point getLocation() {
        return this.location;
    }

    protected Component getLocationRelativeTo() {
        return this.locationRelativeTo;
    }

    protected Dimension getPreferredSize() {
        return this.preferredSize;
    }

    protected abstract JComponent createDialogContentPane();

    protected final void attachListeners() {
        this.dialog.addWindowFocusListener(this.dialogEventHandler);
        this.dialog.addWindowListener(this.dialogEventHandler);
    }

    protected JComponent createButtonBar() {
        this.dialogCommandGroup = CommandGroup.createCommandGroup(null, this.getCommandGroupMembers());
        JComponent buttonBar = this.dialogCommandGroup.createButtonBar();
        GuiStandardUtils.attachDialogBorder(buttonBar);
        return buttonBar;
    }

    protected Object[] getCommandGroupMembers() {
        return new AbstractCommand[]{this.getFinishCommand(), this.getCancelCommand()};
    }

    protected void registerDefaultCommand() {
        if (this.isControlCreated()) {
            this.finishCommand.setDefaultButtonIn(this.getDialog());
        }
    }

    protected final void registerCancelCommandAsDefault() {
        if (this.isControlCreated()) {
            this.cancelCommand.setDefaultButtonIn(this.getDialog());
        }
    }

    protected final void registerDefaultCommand(ActionCommand command) {
        if (this.isControlCreated()) {
            command.setDefaultButtonIn(this.getDialog());
        }
    }

    protected void onInitialized() {
    }

    protected void onAboutToShow() {
    }

    protected void onWindowGainedFocus() {
    }

    protected void onWindowActivated() {
    }

    protected void onWindowLostFocus() {
    }

    protected void onWindowClosing() {
    }

    protected void onCancel() {
        this.executeCloseAction();
    }

    private void executeCloseAction() {
        if (this.closeAction == CloseAction.HIDE) {
            this.hide();
        } else {
            this.dispose();
        }
    }

    protected final void dispose() {
        if (this.dialog != null) {
            this.onWindowClosing();
            this.disposeDialogContentPane();
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    protected void disposeDialogContentPane() {
    }

    protected final void hide() {
        if (this.dialog != null) {
            this.onWindowClosing();
            this.dialog.setVisible(false);
        }
    }

    public Window getParentWindow() {
        if (this.parentWindow == null) {
            this.parentWindow = this.parentComponent == null && this.getActiveWindow() != null ? this.getActiveWindow().getControl() : ApplicationDialog.getWindowForComponent(this.parentComponent);
        }
        return this.parentWindow;
    }

    private class DialogEventHandler
    extends WindowAdapter
    implements WindowFocusListener {
        private DialogEventHandler() {
        }

        public void windowActivated(WindowEvent e) {
            ApplicationDialog.this.onWindowActivated();
        }

        public void windowClosing(WindowEvent e) {
            ApplicationDialog.this.getCancelCommand().execute();
        }

        public void windowGainedFocus(WindowEvent e) {
            ApplicationDialog.this.onWindowGainedFocus();
        }

        public void windowLostFocus(WindowEvent e) {
            ApplicationDialog.this.onWindowLostFocus();
        }
    }
}

