/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.util.EventListenerListHelper;
import org.springframework.util.ObjectUtils;

public class DefaultMessageAreaModel
implements Messagable {
    private Messagable delegate;
    private Message message = DefaultMessage.EMPTY_MESSAGE;
    private EventListenerListHelper listenerList = new EventListenerListHelper(PropertyChangeListener.class);

    public DefaultMessageAreaModel() {
        this.delegate = this;
    }

    public DefaultMessageAreaModel(Messagable delegate) {
        this.delegate = delegate;
    }

    protected Messagable getDelegateFor() {
        return this.delegate;
    }

    public Message getMessage() {
        return this.message;
    }

    public boolean hasInfoMessage() {
        return this.message.getSeverity() == Severity.INFO;
    }

    public boolean hasErrorMessage() {
        return this.message.getSeverity() == Severity.ERROR;
    }

    public boolean hasWarningMessage() {
        return this.message.getSeverity() == Severity.WARNING;
    }

    public void setMessage(Message message) {
        if (message == null) {
            message = DefaultMessage.EMPTY_MESSAGE;
        }
        if (ObjectUtils.nullSafeEquals((Object)this.message, (Object)message)) {
            return;
        }
        Message oldMsg = this.message;
        this.message = message;
        this.fireMessageUpdated(oldMsg, this.message);
    }

    public void renderMessage(JComponent component) {
        this.message.renderMessage(component);
    }

    protected void fireMessageUpdated(Message oldMsg, Message newMsg) {
        this.listenerList.fire("propertyChange", new PropertyChangeEvent(this.delegate, "message", oldMsg, newMsg));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.add(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if ("message".equals(propertyName)) {
            this.listenerList.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.remove(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if ("message".equals(propertyName)) {
            this.listenerList.remove(listener);
        }
    }
}

