/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.config.ApplicationObjectConfigurer;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.core.DescriptionConfigurable;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.core.TitleConfigurable;
import org.springframework.richclient.dialog.ApplicationDialog;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.richclient.widget.SelectionWidget;
import org.springframework.richclient.widget.TitledWidget;
import org.springframework.richclient.widget.Widget;

public class TitledWidgetApplicationDialog
extends ApplicationDialog
implements DescriptionConfigurable,
Messagable {
    public static final String OK_COMMAND_ID = "okCommand";
    public static final String CANCEL_COMMAND_ID = "cancelCommand";
    public static final String EXIT_COMMAND_ID = "exit";
    public static final String SELECT_COMMAND_ID = "select";
    public static final String SELECT_NONE_COMMAND_ID = "selectNoneCommand";
    public static final int OK_MODE = 1;
    public static final int CANCEL_MODE = 2;
    public static final int SELECT_CANCEL_MODE = 3;
    private final Widget widget;
    private final int mode;
    private final String finishId;
    private final String cancelId;
    private final String titledWidgetId;
    private ActionCommand selectNoneCommand;

    public TitledWidgetApplicationDialog(Widget widget) {
        this(widget, 1);
    }

    public TitledWidgetApplicationDialog(Widget widget, int mode) {
        this(widget, mode, mode == 3 ? SELECT_COMMAND_ID : EXIT_COMMAND_ID, EXIT_COMMAND_ID);
    }

    public TitledWidgetApplicationDialog(Widget widget, int mode, String finishId, String cancelId) {
        this.widget = widget;
        this.mode = mode;
        this.finishId = finishId;
        this.cancelId = cancelId;
        this.titledWidgetId = widget instanceof TitledWidget ? ((TitledWidget)widget).getId() : null;
    }

    public Widget getWidget() {
        return this.widget;
    }

    protected JComponent createButtonBar() {
        CommandGroup widgetCommands = CommandGroup.createCommandGroup(null, this.widget.getCommands());
        CommandGroup dialogCommands = CommandGroup.createCommandGroup(this.getCommandGroupMembers());
        JPanel panel = new JPanel((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.GLUE_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC}));
        CellConstraints cc = new CellConstraints();
        panel.add((Component)widgetCommands.createButtonBar(), cc.xy(1, 1));
        panel.add((Component)dialogCommands.createButtonBar(), cc.xy(4, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        return panel;
    }

    protected Object[] getCommandGroupMembers() {
        if (this.mode == 3) {
            return new Object[]{this.getFinishCommand(), this.getSelectNoneCommand(), this.getCancelCommand()};
        }
        if (this.mode == 1) {
            return new Object[]{this.getFinishCommand()};
        }
        if (this.mode == 2) {
            return new Object[]{this.getCancelCommand()};
        }
        return new Object[]{this.getCancelCommand()};
    }

    protected ActionCommand getSelectNoneCommand() {
        if (this.selectNoneCommand == null) {
            this.selectNoneCommand = new ActionCommand(this.getSelectNoneCommandId()){

                public void doExecuteCommand() {
                    TitledWidgetApplicationDialog.this.onSelectNone();
                }
            };
            this.selectNoneCommand.setSecurityControllerId(this.getFinishSecurityControllerId());
        }
        return this.selectNoneCommand;
    }

    private String getSelectNoneCommandId() {
        return SELECT_NONE_COMMAND_ID;
    }

    protected void addDialogComponents() {
        JComponent dialogContentPane = this.createDialogContentPane();
        if (this.getPreferredSize() != null) {
            dialogContentPane.setSize(this.getPreferredSize());
        }
        if (!(this.widget instanceof TitledWidget)) {
            GuiStandardUtils.attachDialogBorder(dialogContentPane);
        }
        this.getDialogContentPane().add(dialogContentPane);
        this.getDialogContentPane().add((Component)this.createButtonBar(), "South");
        if (this.titledWidgetId != null) {
            ((ApplicationObjectConfigurer)Application.services().getService(ApplicationObjectConfigurer.class)).configure(this.widget, this.titledWidgetId);
        }
    }

    protected void onAboutToShow() {
        super.onAboutToShow();
        if (this.mode == 3 && this.widget instanceof SelectionWidget) {
            ((SelectionWidget)this.widget).setSelectionCommand(this.getFinishCommand());
        }
        this.widget.onAboutToShow();
    }

    protected void onWindowClosing() {
        this.widget.onAboutToHide();
        if (this.mode == 3 && this.widget instanceof SelectionWidget) {
            ((SelectionWidget)this.widget).removeSelectionCommand();
        }
        super.onWindowClosing();
    }

    protected boolean onFinish() {
        return true;
    }

    protected boolean onSelectNone() {
        this.getFinishCommand().execute();
        return true;
    }

    protected JComponent createDialogContentPane() {
        return this.widget.getComponent();
    }

    public void setTitle(String title) {
        super.setTitle(title);
        if (this.widget instanceof TitleConfigurable && this.titledWidgetId == null) {
            ((TitleConfigurable)((Object)this.widget)).setTitle(title);
        }
    }

    protected String getFinishCommandId() {
        return this.finishId;
    }

    protected String getCancelCommandId() {
        return this.cancelId;
    }

    public void setCaption(String shortDescription) {
        if (this.widget instanceof DescriptionConfigurable) {
            ((DescriptionConfigurable)((Object)this.widget)).setCaption(shortDescription);
        }
    }

    public void setDescription(String longDescription) {
        if (this.widget instanceof DescriptionConfigurable) {
            ((DescriptionConfigurable)((Object)this.widget)).setDescription(longDescription);
        }
    }

    public void setMessage(Message message) {
        if (this.widget instanceof Messagable) {
            ((Messagable)((Object)this.widget)).setMessage(message);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.widget instanceof Messagable) {
            ((Messagable)((Object)this.widget)).addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener propertyChangeListener) {
        if (this.widget instanceof Messagable) {
            ((Messagable)((Object)this.widget)).addPropertyChangeListener(property, propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.widget instanceof Messagable) {
            ((Messagable)((Object)this.widget)).removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener propertyChangeListener) {
        if (this.widget instanceof Messagable) {
            ((Messagable)((Object)this.widget)).removePropertyChangeListener(property, propertyChangeListener);
        }
    }
}

