/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog.control;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.springframework.richclient.dialog.control.Tab;
import org.springframework.richclient.factory.ControlFactory;
import org.springframework.richclient.util.EventListenerListHelper;

public class ExtTabbedPane
implements ControlFactory {
    private List tabs = new ArrayList();
    private JTabbedPane tabbedPane;
    private PropertyChangeListener propertyChangeHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            int index;
            Tab tab = (Tab)evt.getSource();
            if (tab.isVisible() && (index = ExtTabbedPane.this.getUIIndex(tab)) >= 0) {
                if (evt.getPropertyName().equals("title")) {
                    ExtTabbedPane.this.tabbedPane.setTitleAt(index, tab.getTitle());
                }
                if (evt.getPropertyName().equals("tooltip")) {
                    ExtTabbedPane.this.tabbedPane.setToolTipTextAt(index, tab.getTooltip());
                }
                if (evt.getPropertyName().equals("icon")) {
                    ExtTabbedPane.this.tabbedPane.setIconAt(index, tab.getIcon());
                }
                if (evt.getPropertyName().equals("component")) {
                    ExtTabbedPane.this.tabbedPane.setComponentAt(index, tab.getComponent());
                }
                if (evt.getPropertyName().equals("mnemonic")) {
                    ExtTabbedPane.this.tabbedPane.setMnemonicAt(index, tab.getMnemonic());
                }
                if (evt.getPropertyName().equals("enabled")) {
                    ExtTabbedPane.this.tabbedPane.setMnemonicAt(index, tab.getMnemonic());
                }
            }
            if (evt.getPropertyName().equals("visible")) {
                ExtTabbedPane.this.updateTabVisibility(tab);
            }
        }
    };
    private EventListenerListHelper changeListeners = new EventListenerListHelper(ChangeListener.class);

    public ExtTabbedPane(JTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
        tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ExtTabbedPane.this.changeListeners.fire("stateChanged", e);
            }
        });
    }

    public ExtTabbedPane() {
        this(new JTabbedPane());
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public JComponent getControl() {
        return this.tabbedPane;
    }

    public void addTab(Tab tab) {
        this.tabs.add(tab);
        if (tab.isVisible()) {
            this.tabbedPane.addTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getTooltip());
        }
        tab.addPropertyChangeListener(this.propertyChangeHandler);
    }

    public Tab getTab(int index) {
        return (Tab)this.tabs.get(index);
    }

    public void removeTab(Tab tab) {
        this.removeTab(this.tabs.indexOf(tab));
    }

    public void addTab(int index, Tab tab) {
        this.tabs.add(index, tab);
        if (tab.isVisible()) {
            this.tabbedPane.insertTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getTooltip(), index);
        }
        tab.addPropertyChangeListener(this.propertyChangeHandler);
    }

    public void removeTab(int index) {
        this.tabbedPane.removeTabAt(index);
        Tab tab = (Tab)this.tabs.remove(index);
        tab.removePropertyChangeListener(this.propertyChangeHandler);
    }

    public void selectTab(Tab tab) {
        int targetIndex;
        if (tab.isVisible() && (targetIndex = this.getUIIndex(tab)) >= 0) {
            this.tabbedPane.setSelectedIndex(targetIndex);
        }
    }

    public int convertUIIndexToModelIndex(int index) {
        int modelIndex = index;
        for (int i = 0; i <= modelIndex; ++i) {
            if (this.getTab(i).isVisible()) continue;
            ++modelIndex;
        }
        return modelIndex;
    }

    public int getUIIndex(Tab tab) {
        return this.convertModelIndexToUIIndex(this.tabs.indexOf(tab));
    }

    public int convertModelIndexToUIIndex(int index) {
        int uiIndex = 0;
        for (int i = 0; i < index; ++i) {
            if (!this.getTab(i).isVisible()) continue;
            ++uiIndex;
        }
        return uiIndex;
    }

    private void updateTabVisibility(Tab tab) {
        if (tab.isVisible()) {
            this.tabbedPane.insertTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getTooltip(), this.getUIIndex(tab));
        } else {
            this.tabbedPane.removeTabAt(this.getUIIndex(tab));
        }
        ChangeEvent event = new ChangeEvent(this.tabbedPane);
        this.changeListeners.fire("stateChanged", event);
    }
}

