/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.exceptionhandling;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.hibernate.validator.InvalidStateException;
import org.hibernate.validator.InvalidValue;
import org.springframework.richclient.exceptionhandling.AbstractDialogExceptionHandler;

public class HibernateValidatorDialogExceptionHandler
extends AbstractDialogExceptionHandler {
    private static final String CAPTION_KEY = "hibernateValidatorDialogExceptionHandler.caption";
    private static final String EXPLANATION_KEY = "hibernateValidatorDialogExceptionHandler.explanation";

    public String resolveExceptionCaption(Throwable throwable) {
        return this.messageSourceAccessor.getMessage(CAPTION_KEY, CAPTION_KEY);
    }

    public Object createExceptionContent(Throwable throwable) {
        if (!(throwable instanceof InvalidStateException)) {
            String ILLEGAL_THROWABLE_ARGUMENT = "Could not handle exception: throwable is not an InvalidStateException:\n" + throwable.getClass().getName();
            this.logger.error((Object)ILLEGAL_THROWABLE_ARGUMENT);
            return ILLEGAL_THROWABLE_ARGUMENT;
        }
        InvalidStateException invalidStateException = (InvalidStateException)throwable;
        String explanation = this.messageSourceAccessor.getMessage(EXPLANATION_KEY, EXPLANATION_KEY);
        JPanel panel = new JPanel(new BorderLayout());
        JLabel explanationLabel = new JLabel(explanation);
        panel.add((Component)explanationLabel, "North");
        ArrayList<String> invalidValueMessageList = new ArrayList<String>();
        for (InvalidValue invalidValue : invalidStateException.getInvalidValues()) {
            StringBuffer messageBuffer = new StringBuffer();
            String propertyName = invalidValue.getPropertyName();
            messageBuffer.append(this.messageSourceAccessor.getMessage(propertyName + ".label", propertyName));
            messageBuffer.append(" ");
            messageBuffer.append(invalidValue.getMessage());
            invalidValueMessageList.add(messageBuffer.toString());
        }
        JList<Object> invalidValuesJList = new JList<Object>(invalidValueMessageList.toArray());
        JScrollPane invalidValuesScrollPane = new JScrollPane(invalidValuesJList, 22, 31);
        panel.add((Component)invalidValuesScrollPane, "Center");
        return panel;
    }
}

