/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.exceptionhandling;

import java.awt.Component;
import java.util.logging.Level;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.springframework.richclient.exceptionhandling.MessagesDialogExceptionHandler;
import org.springframework.richclient.exceptionhandling.ShutdownPolicy;

public class JXErrorDialogExceptionHandler
extends MessagesDialogExceptionHandler {
    private ErrorReporter errorReporter;

    public void setShutdownPolicy(ShutdownPolicy shutdownPolicy) {
        throw new UnsupportedOperationException("JXErrorDialogExceptionHandler does not support setting of ShutdownPolicy");
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public void notifyUserAboutException(Thread thread, Throwable throwable) {
        ErrorInfo errorInfo = new ErrorInfo(this.resolveExceptionCaption(throwable), (String)this.createExceptionContent(throwable), JXErrorDialogExceptionHandler.getDetailsAsHTML(throwable.getMessage(), this.resolveMessageType(), throwable), null, throwable, this.resolveMessageType(), null);
        JXErrorPane pane = new JXErrorPane();
        pane.setErrorInfo(errorInfo);
        if (this.errorReporter != null) {
            pane.setErrorReporter(this.errorReporter);
        }
        JXErrorPane.showDialog((Component)this.resolveParentFrame(), (JXErrorPane)pane);
    }

    private Level resolveMessageType() {
        switch (this.logLevel) {
            case TRACE: {
                return Level.FINEST;
            }
            case DEBUG: {
                return Level.FINER;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARNING;
            }
        }
        return Level.SEVERE;
    }

    private static String escapeXml(String input) {
        return input == null ? "" : input.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static String getDetailsAsHTML(String title, Level level, Throwable e) {
        if (e != null) {
            StringBuffer html = new StringBuffer("<html>");
            html.append("<h2>" + JXErrorDialogExceptionHandler.escapeXml(title) + "</h2>");
            html.append("<HR size='1' noshade>");
            html.append("<div></div>");
            html.append("<b>Message:</b>");
            html.append("<pre>");
            html.append("    " + JXErrorDialogExceptionHandler.escapeXml(e.toString()));
            html.append("</pre>");
            html.append("<b>Level:</b>");
            html.append("<pre>");
            html.append("    " + level);
            html.append("</pre>");
            html.append("<b>Stack Trace:</b>");
            html.append("<pre>");
            for (StackTraceElement el : e.getStackTrace()) {
                html.append("    " + el.toString().replace("<init>", "&lt;init&gt;") + "\n");
            }
            if (e.getCause() != null) {
                html.append("</pre>");
                html.append("<b>Cause:</b>");
                html.append("<pre>");
                html.append(e.getCause().getMessage());
                html.append("</pre><pre>");
                for (StackTraceElement el : e.getCause().getStackTrace()) {
                    html.append("    " + el.toString().replace("<init>", "&lt;init&gt;") + "\n");
                }
            }
            html.append("</pre></html>");
            return html.toString();
        }
        return null;
    }
}

