/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.exceptionhandling.delegation;

import org.springframework.richclient.exceptionhandling.delegation.ExceptionHandlerDelegate;
import org.springframework.richclient.exceptionhandling.delegation.ExceptionPurger;

public abstract class AbstractExceptionHandlerDelegate
implements ExceptionHandlerDelegate {
    protected Thread.UncaughtExceptionHandler exceptionHandler;
    protected ExceptionPurger exceptionPurger = null;
    protected boolean purgeOnAppropriateCheck = true;
    protected boolean purgeOnHandling = true;

    public AbstractExceptionHandlerDelegate() {
    }

    public AbstractExceptionHandlerDelegate(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setExceptionPurger(ExceptionPurger exceptionPurger) {
        this.exceptionPurger = exceptionPurger;
    }

    public void setPurgeOnAppropriateCheck(boolean purgeOnAppropriateCheck) {
        this.purgeOnAppropriateCheck = purgeOnAppropriateCheck;
    }

    public void setPurgeOnHandling(boolean purgeOnHandling) {
        this.purgeOnHandling = purgeOnHandling;
    }

    public final boolean hasAppropriateHandler(Throwable throwable) {
        if (this.exceptionPurger != null && this.purgeOnAppropriateCheck) {
            throwable = this.exceptionPurger.purge(throwable);
        }
        return this.hasAppropriateHandlerPurged(throwable);
    }

    public abstract boolean hasAppropriateHandlerPurged(Throwable var1);

    public final void uncaughtException(Thread thread, Throwable throwable) {
        if (this.exceptionPurger != null && this.purgeOnHandling) {
            throwable = this.exceptionPurger.purge(throwable);
        }
        this.uncaughtExceptionPurged(thread, throwable);
    }

    public void uncaughtExceptionPurged(Thread thread, Throwable throwable) {
        this.exceptionHandler.uncaughtException(thread, throwable);
    }
}

