/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.factory;

import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.value.ValueModel;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.core.enums.LabeledEnumResolver;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.command.config.CommandButtonLabelInfo;
import org.springframework.richclient.components.PatchedJFormattedTextField;
import org.springframework.richclient.core.LabelInfo;
import org.springframework.richclient.factory.ButtonFactory;
import org.springframework.richclient.factory.ComponentFactory;
import org.springframework.richclient.factory.MenuFactory;
import org.springframework.richclient.factory.TableFactory;
import org.springframework.richclient.image.IconSource;
import org.springframework.richclient.list.ComboBoxListModel;
import org.springframework.richclient.list.LabeledEnumComboBoxEditor;
import org.springframework.richclient.list.LabeledEnumListRenderer;
import org.springframework.richclient.util.Alignment;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.util.comparator.ComparableComparator;
import org.springframework.util.comparator.CompoundComparator;

public class DefaultComponentFactory
implements ComponentFactory,
MessageSourceAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private MessageSourceAccessor messages;
    private IconSource iconSource;
    private ButtonFactory buttonFactory;
    private MenuFactory menuFactory;
    private LabeledEnumResolver enumResolver;
    private MessageSource messageSource;
    private TableFactory tableFactory;
    private int textFieldColumns = 25;

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setIconSource(IconSource iconSource) {
        this.iconSource = iconSource;
    }

    public void setButtonFactory(ButtonFactory buttonFactory) {
        this.buttonFactory = buttonFactory;
    }

    public void setMenuFactory(MenuFactory menuFactory) {
        this.menuFactory = menuFactory;
    }

    public void setEnumResolver(LabeledEnumResolver enumResolver) {
        this.enumResolver = enumResolver;
    }

    protected LabeledEnumResolver getEnumResolver() {
        if (this.enumResolver == null) {
            this.enumResolver = (LabeledEnumResolver)ApplicationServicesLocator.services().getService(LabeledEnumResolver.class);
        }
        return this.enumResolver;
    }

    public JLabel createLabel(String labelKey) {
        JLabel label = this.createNewLabel();
        this.getLabelInfo(this.getRequiredMessage(labelKey)).configureLabel(label);
        return label;
    }

    public JLabel createLabel(String[] labelKeys) {
        JLabel label = this.createNewLabel();
        this.getLabelInfo(this.getRequiredMessage(labelKeys)).configureLabel(label);
        return label;
    }

    public JLabel createLabel(String labelKey, Object[] arguments) {
        JLabel label = this.createNewLabel();
        this.getLabelInfo(this.getRequiredMessage(labelKey, arguments)).configureLabel(label);
        return label;
    }

    protected LabelInfo getLabelInfo(String label) {
        return LabelInfo.valueOf(label);
    }

    protected String getRequiredMessage(String messageKey) {
        return this.getRequiredMessage(messageKey, null);
    }

    protected String getRequiredMessage(final String[] messageKeys) {
        MessageSourceResolvable resolvable = new MessageSourceResolvable(){

            public String[] getCodes() {
                return messageKeys;
            }

            public Object[] getArguments() {
                return null;
            }

            public String getDefaultMessage() {
                if (messageKeys.length > 0) {
                    return messageKeys[0];
                }
                return "";
            }
        };
        return this.getMessages().getMessage(resolvable);
    }

    private MessageSourceAccessor getMessages() {
        if (this.messages == null) {
            this.messages = (MessageSourceAccessor)ApplicationServicesLocator.services().getService(MessageSourceAccessor.class);
        }
        return this.messages;
    }

    public JLabel createLabel(String labelKey, ValueModel[] argumentValueHolders) {
        return new LabelTextRefresher(labelKey, argumentValueHolders).getLabel();
    }

    private String getRequiredMessage(String messageKey, Object[] args) {
        try {
            String message = this.getMessages().getMessage(messageKey, args);
            return message;
        }
        catch (NoSuchMessageException e) {
            return messageKey;
        }
    }

    public JLabel createTitleLabel(String labelKey) {
        return com.jgoodies.forms.factories.DefaultComponentFactory.getInstance().createTitle(this.getRequiredMessage(labelKey));
    }

    public JComponent createTitledBorderFor(String labelKey, JComponent component) {
        component.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.getRequiredMessage(labelKey)), GuiStandardUtils.createEvenlySpacedBorder(5)));
        return component;
    }

    public JLabel createLabelFor(String labelKey, JComponent component) {
        JLabel label = this.createNewLabel();
        this.getLabelInfo(this.getRequiredMessage(labelKey)).configureLabelFor(label, component);
        return label;
    }

    public JLabel createLabelFor(String[] labelKeys, JComponent component) {
        JLabel label = this.createNewLabel();
        this.getLabelInfo(this.getRequiredMessage(labelKeys)).configureLabelFor(label, component);
        return label;
    }

    protected JLabel createNewLabel() {
        return new JLabel();
    }

    public JButton createButton(String labelKey) {
        return (JButton)this.getButtonLabelInfo(this.getRequiredMessage(labelKey)).configure(this.getButtonFactory().createButton());
    }

    protected CommandButtonLabelInfo getButtonLabelInfo(String label) {
        return CommandButtonLabelInfo.valueOf(label);
    }

    protected ButtonFactory getButtonFactory() {
        if (this.buttonFactory == null) {
            this.buttonFactory = (ButtonFactory)ApplicationServicesLocator.services().getService(ButtonFactory.class);
        }
        return this.buttonFactory;
    }

    public JComponent createLabeledSeparator(String labelKey) {
        return this.createLabeledSeparator(labelKey, Alignment.LEFT);
    }

    public JCheckBox createCheckBox(String labelKey) {
        return (JCheckBox)this.getButtonLabelInfo(this.getRequiredMessage(labelKey)).configure(this.createNewCheckBox());
    }

    public JCheckBox createCheckBox(String[] labelKeys) {
        return (JCheckBox)this.getButtonLabelInfo(this.getRequiredMessage(labelKeys)).configure(this.createNewCheckBox());
    }

    protected JCheckBox createNewCheckBox() {
        return new JCheckBox();
    }

    public JToggleButton createToggleButton(String labelKey) {
        return (JToggleButton)this.getButtonLabelInfo(this.getRequiredMessage(labelKey)).configure(this.createNewToggleButton());
    }

    public JToggleButton createToggleButton(String[] labelKeys) {
        return (JToggleButton)this.getButtonLabelInfo(this.getRequiredMessage(labelKeys)).configure(this.createNewToggleButton());
    }

    protected AbstractButton createNewToggleButton() {
        return new JToggleButton();
    }

    public JRadioButton createRadioButton(String labelKey) {
        return (JRadioButton)this.getButtonLabelInfo(this.getRequiredMessage(labelKey)).configure(this.createNewRadioButton());
    }

    protected JRadioButton createNewRadioButton() {
        return new JRadioButton();
    }

    public JRadioButton createRadioButton(String[] labelKeys) {
        return (JRadioButton)this.getButtonLabelInfo(this.getRequiredMessage(labelKeys)).configure(this.createNewRadioButton());
    }

    public JMenuItem createMenuItem(String labelKey) {
        return (JMenuItem)this.getButtonLabelInfo(this.getRequiredMessage(labelKey)).configure(this.getMenuFactory().createMenuItem());
    }

    protected MenuFactory getMenuFactory() {
        if (this.menuFactory == null) {
            this.menuFactory = (MenuFactory)ApplicationServicesLocator.services().getService(MenuFactory.class);
        }
        return this.menuFactory;
    }

    public JComponent createLabeledSeparator(String labelKey, Alignment alignment) {
        return com.jgoodies.forms.factories.DefaultComponentFactory.getInstance().createSeparator(this.getRequiredMessage(labelKey), ((Number)((Object)alignment.getCode())).intValue());
    }

    public JList createList() {
        return new JList();
    }

    public JComboBox createComboBox() {
        return new JComboBox();
    }

    public JComboBox createComboBox(Class enumType) {
        JComboBox comboBox = this.createComboBox();
        this.configureForEnum(comboBox, enumType);
        return comboBox;
    }

    public JComboBox createListValueModelComboBox(ValueModel selectedItemValueModel, ValueModel selectableItemsListHolder, String renderedPropertyPath) {
        return null;
    }

    public void configureForEnum(JComboBox comboBox, Class enumType) {
        Set enumValues = this.getEnumResolver().getLabeledEnumSet(enumType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Populating combo box model with enums of type '" + enumType.getName() + "'; enums are [" + enumValues + "]"));
        }
        CompoundComparator comparator = new CompoundComparator();
        comparator.addComparator(LabeledEnum.LABEL_ORDER);
        comparator.addComparator((Comparator)new ComparableComparator());
        comboBox.setModel(new ComboBoxListModel(new ArrayList(enumValues), (Comparator)comparator));
        comboBox.setRenderer(new LabeledEnumListRenderer(this.messageSource));
        comboBox.setEditor(new LabeledEnumComboBoxEditor(this.messageSource, comboBox.getEditor()));
    }

    public int getTextFieldColumns() {
        return this.textFieldColumns;
    }

    public void setTextFieldColumns(int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException("text field columns must not be lower than 0. Value was: " + columns);
        }
        this.textFieldColumns = columns;
    }

    public JFormattedTextField createFormattedTextField(JFormattedTextField.AbstractFormatterFactory formatterFactory) {
        PatchedJFormattedTextField patchedJFormattedTextField = new PatchedJFormattedTextField(formatterFactory);
        this.configureTextField(patchedJFormattedTextField);
        return patchedJFormattedTextField;
    }

    public JTextField createTextField() {
        JTextField textField = new JTextField();
        this.configureTextField(textField);
        return textField;
    }

    protected void configureTextField(JTextField textField) {
        textField.setColumns(this.getTextFieldColumns());
    }

    public JPasswordField createPasswordField() {
        JPasswordField passwordField = new JPasswordField();
        this.configureTextField(passwordField);
        return passwordField;
    }

    public JTextArea createTextArea() {
        return new JTextArea();
    }

    public JTextArea createTextArea(int rows, int columns) {
        JTextArea textArea = this.createTextArea();
        textArea.setRows(rows);
        textArea.setColumns(columns);
        return textArea;
    }

    public JTextArea createTextAreaAsLabel() {
        return GuiStandardUtils.textAreaAsLabel(this.createTextArea());
    }

    public JTabbedPane createTabbedPane() {
        return new JTabbedPane();
    }

    public void addConfiguredTab(JTabbedPane tabbedPane, String labelKey, JComponent tabComponent) {
        LabelInfo info = this.getLabelInfo(this.getRequiredMessage(labelKey));
        tabbedPane.addTab(info.getText(), tabComponent);
        int tabIndex = tabbedPane.getTabCount() - 1;
        tabbedPane.setMnemonicAt(tabIndex, info.getMnemonic());
        tabbedPane.setDisplayedMnemonicIndexAt(tabIndex, info.getMnemonicIndex());
        tabbedPane.setIconAt(tabIndex, this.getIcon(labelKey));
        tabbedPane.setToolTipTextAt(tabIndex, this.getCaption(labelKey));
    }

    public JScrollPane createScrollPane() {
        return new JScrollPane();
    }

    public JScrollPane createScrollPane(Component view) {
        return new JScrollPane(view);
    }

    public JScrollPane createScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        return new JScrollPane(view, vsbPolicy, hsbPolicy);
    }

    public JPanel createPanel() {
        return new JPanel();
    }

    public JPanel createPanel(LayoutManager layoutManager) {
        return new JPanel(layoutManager);
    }

    private String getCaption(String labelKey) {
        return this.getOptionalMessage(labelKey + ".caption");
    }

    protected String getOptionalMessage(String messageKey) {
        return this.getMessages().getMessage(messageKey, (String)null);
    }

    private Icon getIcon(String labelKey) {
        return this.getIconSource().getIcon(labelKey);
    }

    private IconSource getIconSource() {
        if (this.iconSource == null) {
            this.iconSource = (IconSource)ApplicationServicesLocator.services().getService(IconSource.class);
        }
        return this.iconSource;
    }

    public JTable createTable() {
        return this.tableFactory != null ? this.tableFactory.createTable() : new JTable();
    }

    public JTable createTable(TableModel model) {
        return this.tableFactory != null ? this.tableFactory.createTable(model) : new JTable(model);
    }

    public void setTableFactory(TableFactory tableFactory) {
        this.tableFactory = tableFactory;
    }

    public JComponent createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        return toolBar;
    }

    private class LabelTextRefresher
    implements PropertyChangeListener {
        private String labelKey;
        private JLabel label;
        private ValueModel[] argumentHolders;

        public LabelTextRefresher(String labelKey, ValueModel[] argumentHolders) {
            this.labelKey = labelKey;
            this.argumentHolders = argumentHolders;
            this.label = DefaultComponentFactory.this.createNewLabel();
            this.subscribe();
            this.updateLabel();
        }

        private void subscribe() {
            for (int i = 0; i < this.argumentHolders.length; ++i) {
                ValueModel argHolder = this.argumentHolders[i];
                argHolder.addValueChangeListener(this);
            }
        }

        public JLabel getLabel() {
            return this.label;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.updateLabel();
        }

        private void updateLabel() {
            Object[] argValues = new Object[this.argumentHolders.length];
            for (int i = 0; i < this.argumentHolders.length; ++i) {
                ValueModel argHolder = this.argumentHolders[i];
                argValues[i] = argHolder.getValue();
            }
            DefaultComponentFactory.this.getLabelInfo(DefaultComponentFactory.this.getRequiredMessage(this.labelKey, argValues)).configureLabel(this.label);
        }
    }
}

