/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.filechooser;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class DefaultFileFilter
extends FileFilter {
    private List extensions = new ArrayList();
    private String description;
    private boolean useExtensionsInDescription = true;

    public DefaultFileFilter() {
    }

    public DefaultFileFilter(String extension) {
        this(extension, null);
    }

    public DefaultFileFilter(String extension, String description) {
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public DefaultFileFilter(String[] extensions) {
        this(extensions, null);
    }

    public DefaultFileFilter(String[] extensions, String description) {
        for (int i = 0; i < extensions.length; ++i) {
            this.addExtension(extensions[i]);
        }
        this.setDescription(description);
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (this.extensions.contains(extension)) {
                return true;
            }
        }
        return false;
    }

    private String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        String ext = this.transformExtension(extension);
        if (!this.extensions.contains(ext)) {
            this.extensions.add(ext);
        }
    }

    public void removeExtension(String extension) {
        String ext = this.transformExtension(extension);
        if (this.extensions.contains(ext)) {
            this.extensions.remove(ext);
        }
    }

    private String transformExtension(String extension) {
        String result = extension.toLowerCase();
        if (result.startsWith("*.")) {
            result = result.substring(2);
        }
        if (result.startsWith(".")) {
            result = result.substring(1);
        }
        return result;
    }

    public List getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public String getDescription() {
        if (this.isExtensionListInDescription() && this.extensions.size() > 0) {
            String extensionList = this.buildExtensionList().toString();
            if (this.description != null) {
                return this.description + " " + extensionList;
            }
            return extensionList;
        }
        return this.description;
    }

    private String buildExtensionList() {
        StringBuffer extensionList = new StringBuffer("(");
        Iterator iter = this.extensions.iterator();
        while (iter.hasNext()) {
            String extension = (String)iter.next();
            extensionList.append("*.").append(extension);
            if (!iter.hasNext()) continue;
            extensionList.append(", ");
        }
        extensionList.append(")");
        return extensionList.toString();
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[DefaultFileFilter description=").append(this.description).append(", extensions=").append(this.extensions);
        return buf.toString();
    }
}

