/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form;

import org.springframework.binding.validation.ValidationMessage;
import org.springframework.binding.validation.ValidationResults;
import org.springframework.binding.validation.ValidationResultsModel;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.form.ValidationResultsReporter;
import org.springframework.util.Assert;

public class SimpleValidationResultsReporter
implements ValidationResultsReporter {
    private ValidationResultsModel resultsModel;
    private Messagable messageReceiver;

    public SimpleValidationResultsReporter(ValidationResultsModel resultsModel, Messagable messageReceiver) {
        Assert.notNull((Object)resultsModel, (String)"resultsModel is required");
        Assert.notNull((Object)messageReceiver, (String)"messagePane is required");
        this.resultsModel = resultsModel;
        this.messageReceiver = messageReceiver;
        this.init();
    }

    private void init() {
        this.resultsModel.addValidationListener(this);
        this.validationResultsChanged(null);
    }

    public void clearErrors() {
        this.messageReceiver.setMessage(null);
    }

    public void validationResultsChanged(ValidationResults results) {
        if (this.resultsModel.getMessageCount() == 0) {
            this.messageReceiver.setMessage(null);
        } else {
            ValidationMessage message = this.getValidationMessage(this.resultsModel);
            this.messageReceiver.setMessage(message);
        }
    }

    protected ValidationMessage getValidationMessage(ValidationResults resultsModel) {
        Message validationMessage = null;
        for (ValidationMessage tmpMessage : resultsModel.getMessages()) {
            if (validationMessage != null && validationMessage.getSeverity().compareTo((Object)tmpMessage.getSeverity()) >= 0 && (validationMessage.getTimestamp() >= tmpMessage.getTimestamp() || validationMessage.getSeverity() != tmpMessage.getSeverity())) continue;
            validationMessage = tmpMessage;
        }
        return validationMessage;
    }

    public boolean hasErrors() {
        return this.resultsModel.getHasErrors();
    }
}

