/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form;

import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.NewFormObjectAware;
import org.springframework.binding.form.ValidatingFormModel;
import org.springframework.binding.form.VetoableCommitListener;
import org.springframework.richclient.components.MessagableTabbedPane;
import org.springframework.richclient.components.SkipComponentsFocusTraversalPolicy;
import org.springframework.richclient.form.AbstractFocussableForm;
import org.springframework.richclient.form.FormModelHelper;
import org.springframework.richclient.util.RcpSupport;
import org.springframework.util.Assert;

public abstract class TabbedForm
extends AbstractFocussableForm
implements ChangeListener,
NewFormObjectAware {
    private List<VetoableCommitListener> vetoableCommitListeners;
    private JTabbedPane tabbedPane = null;

    public TabbedForm(Object formObject, String formId) {
        this((FormModel)FormModelHelper.createFormModel(formObject), formId);
    }

    public TabbedForm(FormModel formModel, String formId) {
        super(formModel, formId);
        if (this.getFormModel().getId() == null) {
            this.getFormModel().setId(formId);
        }
    }

    public TabbedForm(FormModel formModel) {
        this(formModel, formModel.getId());
    }

    protected JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    protected final JComponent createFormControl() {
        this.tabbedPane = new MessagableTabbedPane(1);
        this.tabbedPane.setFocusTraversalPolicyProvider(true);
        this.tabbedPane.setFocusTraversalPolicy(SkipComponentsFocusTraversalPolicy.skipJTextComponentTraversalPolicy);
        for (Tab tab : this.getTabs()) {
            tab.setParent(this.tabbedPane);
        }
        this.tabbedPane.addChangeListener(this);
        return this.tabbedPane;
    }

    public JComponent getRevertComponent() {
        return this.getRevertCommand().createButton();
    }

    public void setFormObject(Object formObject) {
        if (formObject == null) {
            this.selectTab(0);
        }
        super.setFormObject(formObject);
    }

    public void setNewFormObject(Object formObject) {
        if (formObject != null) {
            super.setFormObject(formObject);
        } else {
            this.getNewFormObjectCommand().execute();
        }
        this.selectTab(0);
    }

    public void selectTab(int tabIndex) {
        if (this.tabbedPane != null && this.tabbedPane.getTabCount() > tabIndex) {
            this.tabbedPane.setSelectedIndex(tabIndex);
        }
    }

    public void selectTab(Tab tab) {
        if (tab.getTabIndex() > 0) {
            this.tabbedPane.setSelectedIndex(tab.getTabIndex());
        }
    }

    protected abstract Tab[] getTabs();

    public void commit() {
        ValidatingFormModel formModel = this.getFormModel();
        if (this.vetoableCommitListeners != null) {
            for (VetoableCommitListener v : this.vetoableCommitListeners) {
                if (v.proceedWithCommit(formModel)) continue;
                return;
            }
        }
        super.commit();
    }

    public void stateChanged(ChangeEvent e) {
    }

    @Deprecated
    public void addVetoableCommitListener(VetoableCommitListener vetoableCommitListener) {
        if (this.vetoableCommitListeners == null) {
            this.vetoableCommitListeners = new ArrayList<VetoableCommitListener>(5);
        }
        this.vetoableCommitListeners.add(vetoableCommitListener);
    }

    @Deprecated
    public void removeVetoableCommitListener(VetoableCommitListener vetoableCommitListener) {
        if (this.vetoableCommitListeners != null) {
            this.vetoableCommitListeners.remove(vetoableCommitListener);
        }
    }

    protected class Tab {
        private final String tabId;
        private final String title;
        private final JComponent panel;
        private FocusTraversalPolicy focusTraversalPolicy;
        private JTabbedPane parentPane;
        private int tabIndex = -1;
        private boolean enabled = true;
        private boolean visible = true;

        public Tab(String tabId, JComponent panel) {
            Assert.notNull((Object)panel);
            this.tabId = tabId;
            this.title = RcpSupport.getMessage(TabbedForm.this.getId(), this.tabId, "title");
            this.panel = panel;
            this.panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }

        protected void setParent(JTabbedPane parentPane) {
            this.parentPane = parentPane;
            if (this.parentPane != null) {
                this.setVisible(this.visible);
            }
        }

        public void setVisible(boolean visible) {
            if (this.parentPane != null) {
                if (visible) {
                    this.parentPane.addTab(this.title, this.panel);
                    this.tabIndex = this.parentPane.indexOfComponent(this.panel);
                    this.parentPane.setEnabledAt(this.tabIndex, this.isEnabled());
                } else {
                    this.parentPane.remove(this.panel);
                    this.tabIndex = -1;
                }
            }
            this.visible = visible;
        }

        public void setEnabled(boolean enabled) {
            if (this.parentPane != null && this.tabIndex > -1) {
                this.parentPane.setEnabledAt(this.tabIndex, enabled);
            }
            this.enabled = enabled;
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setMarked(boolean enable) {
            Icon icon = RcpSupport.getIcon(this.tabId + ".icon");
            if (this.parentPane != null && this.tabIndex > -1) {
                this.parentPane.setIconAt(this.getTabIndex(), enable ? icon : null);
            }
        }

        public void setFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
            this.focusTraversalPolicy = focusTraversalPolicy;
            this.panel.setFocusTraversalPolicy(this.focusTraversalPolicy);
            this.panel.setFocusTraversalPolicyProvider(this.focusTraversalPolicy != null);
        }
    }
}

