/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.binding.form.FormModel;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.richclient.form.binding.Binder;
import org.springframework.richclient.form.binding.BinderSelectionStrategy;
import org.springframework.richclient.util.ClassUtils;
import org.springframework.util.Assert;

public abstract class AbstractBinderSelectionStrategy
implements BinderSelectionStrategy,
ApplicationContextAware,
InitializingBean {
    private final Class defaultControlType;
    private final ClassEditor classEditor = new ClassEditor();
    private final Map controlTypeBinders = new HashMap();
    private final Map propertyTypeBinders = new HashMap();
    private final Map propertyNameBinders = new HashMap();
    private List bindersForPropertyNames = new ArrayList();
    private ApplicationContext applicationContext;

    public AbstractBinderSelectionStrategy(Class defaultControlType) {
        this.defaultControlType = defaultControlType;
        this.registerDefaultBinders();
    }

    public Binder selectBinder(FormModel formModel, String propertyName) {
        Binder binder = this.findBinderByPropertyName(formModel.getFormObject().getClass(), propertyName);
        if (binder == null) {
            binder = this.findBinderByPropertyType(this.getPropertyType(formModel, propertyName));
        }
        if (binder == null) {
            binder = this.selectBinder(this.defaultControlType, formModel, propertyName);
        }
        if (binder != null) {
            return binder;
        }
        throw new UnsupportedOperationException("Unable to select a binder for form model [" + formModel + "] property [" + propertyName + "]");
    }

    public Binder selectBinder(Class controlType, FormModel formModel, String propertyName) {
        Binder binder = this.findBinderByControlType(controlType);
        if (binder == null) {
            binder = this.selectBinder(formModel, propertyName);
        }
        if (binder != null) {
            return binder;
        }
        throw new UnsupportedOperationException("Unable to select a binder for form model [" + formModel + "] property [" + propertyName + "]");
    }

    protected abstract void registerDefaultBinders();

    protected Binder findBinderByPropertyName(Class parentObjectType, String propertyName) {
        PropertyNameKey key = new PropertyNameKey(parentObjectType, propertyName);
        Binder binder = (Binder)this.propertyNameBinders.get(key);
        if (binder == null) {
            HashMap potentialMatchingBinders = new HashMap();
            for (Map.Entry entry : this.propertyNameBinders.entrySet()) {
                if (!((PropertyNameKey)entry.getKey()).getPropertyName().equals(propertyName)) continue;
                potentialMatchingBinders.put(((PropertyNameKey)entry.getKey()).getParentObjectType(), entry.getValue());
            }
            binder = (Binder)ClassUtils.getValueFromMapForClass(parentObjectType, potentialMatchingBinders);
            if (binder != null) {
                this.registerBinderForPropertyName(parentObjectType, propertyName, binder);
            }
        }
        return binder;
    }

    protected Binder findBinderByPropertyType(Class propertyType) {
        return (Binder)ClassUtils.getValueFromMapForClass(propertyType, this.propertyTypeBinders);
    }

    protected Binder findBinderByControlType(Class controlType) {
        return (Binder)ClassUtils.getValueFromMapForClass(controlType, this.controlTypeBinders);
    }

    protected void registerBinderForPropertyName(Class parentObjectType, String propertyName, Binder binder) {
        this.propertyNameBinders.put(new PropertyNameKey(parentObjectType, propertyName), binder);
    }

    public void setBindersForPropertyNames(List binders) {
        this.bindersForPropertyNames = binders;
    }

    public void setBinderForPropertyName(Properties binder) {
        String objectClassName = (String)binder.get("objectClass");
        if (objectClassName == null) {
            throw new IllegalArgumentException("objectClass is required");
        }
        this.classEditor.setAsText(objectClassName);
        Class objectClass = (Class)this.classEditor.getValue();
        String propertyName = (String)binder.get("propertyName");
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName is required");
        }
        if (binder.containsKey("binder")) {
            Object binderParameter = binder.get("binder");
            this.classEditor.setAsText((String)binderParameter);
            Class binderClass = (Class)this.classEditor.getValue();
            try {
                this.registerBinderForPropertyName(objectClass, propertyName, (Binder)binderClass.newInstance());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not instantiate new binder with default constructor: " + binderParameter);
            }
        } else if (binder.containsKey("binderRef")) {
            String binderID = (String)binder.get("binderRef");
            Binder binderBean = (Binder)this.getApplicationContext().getBean(binderID);
            this.registerBinderForPropertyName(objectClass, propertyName, binderBean);
        } else {
            throw new IllegalArgumentException("binder or binderRef is required");
        }
    }

    protected void registerBinderForPropertyType(Class propertyType, Binder binder) {
        this.propertyTypeBinders.put(propertyType, binder);
    }

    public void setBindersForPropertyTypes(Map binders) {
        for (Map.Entry entry : binders.entrySet()) {
            this.registerBinderForPropertyType((Class)entry.getKey(), (Binder)entry.getValue());
        }
    }

    protected void registerBinderForControlType(Class controlType, Binder binder) {
        this.controlTypeBinders.put(controlType, binder);
    }

    public void setBindersForControlTypes(Map binders) {
        for (Map.Entry entry : binders.entrySet()) {
            this.registerBinderForControlType((Class)entry.getKey(), (Binder)entry.getValue());
        }
    }

    protected Class getPropertyType(FormModel formModel, String formPropertyPath) {
        return formModel.getFieldMetadata(formPropertyPath).getPropertyType();
    }

    protected boolean isEnumeration(FormModel formModel, String formPropertyPath) {
        return LabeledEnum.class.isAssignableFrom(this.getPropertyType(formModel, formPropertyPath));
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Iterator i = this.bindersForPropertyNames.iterator();
        while (i.hasNext()) {
            this.setBinderForPropertyName((Properties)i.next());
        }
    }

    private static class PropertyNameKey {
        private final Class parentObjectType;
        private final String propertyName;

        public PropertyNameKey(Class parentObjectType, String propertyName) {
            Assert.notNull((Object)parentObjectType, (String)"parentObjectType must not be null.");
            Assert.notNull((Object)propertyName, (String)"propertyName must not be null.");
            this.parentObjectType = parentObjectType;
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Class getParentObjectType() {
            return this.parentObjectType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyNameKey)) {
                return false;
            }
            PropertyNameKey propertyNameKey = (PropertyNameKey)o;
            return this.propertyName.equals(propertyNameKey.propertyName) && this.parentObjectType.equals(propertyNameKey.parentObjectType);
        }

        public int hashCode() {
            return this.propertyName.hashCode() * 29 + this.parentObjectType.hashCode();
        }
    }
}

