/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.components.Focussable;
import org.springframework.richclient.dialog.ApplicationDialog;
import org.springframework.richclient.dialog.TitledApplicationDialog;
import org.springframework.richclient.form.AbstractFocussableForm;
import org.springframework.richclient.form.AbstractForm;
import org.springframework.richclient.form.binding.support.AbstractCRUDBinding;
import org.springframework.richclient.util.RcpSupport;
import org.springframework.richclient.widget.table.TableDescription;
import org.springframework.richclient.widget.table.TableWidget;
import org.springframework.richclient.widget.table.glazedlists.GlazedListTableWidget;

public abstract class AbstractGlazedListsBinding
extends AbstractCRUDBinding {
    protected Object viewControllerObject;
    private static final int ADD_MODE = 1;
    private static final int EDIT_MODE = 2;
    private static final int DETAIL_MODE = 3;
    protected int currentMode = 1;
    protected GlazedListTableWidget table;
    protected ApplicationDialog formDialog;
    protected AbstractForm form;
    protected String dialogId;
    protected boolean useOriginalSortOrder;
    private AbstractForm detailForm;
    private ApplicationDialog detailFormDialog;

    public AbstractGlazedListsBinding(FormModel formModel, String formPropertyPath) {
        this(formModel, formPropertyPath, false);
    }

    public AbstractGlazedListsBinding(FormModel formModel, String formPropertyPath, boolean useOriginalSortOrder) {
        super(formModel, formPropertyPath, null);
        this.useOriginalSortOrder = useOriginalSortOrder;
    }

    protected final void valueModelChanged(Object newValue) {
        this.viewControllerObject = RcpSupport.getClone(newValue);
        this.table.setRows(this.getList(this.viewControllerObject));
        this.onValueModelChanged();
        this.readOnlyChanged();
    }

    protected void onValueModelChanged() {
    }

    protected final void listChanged() {
        this.controlValueChanged(RcpSupport.getClone(this.viewControllerObject));
        this.table.setRows(this.getList(this.viewControllerObject));
    }

    protected JComponent doBindControl() {
        this.getTable();
        JPanel editor = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 853322345395517384L;

            public void setEnabled(boolean enable) {
                AbstractGlazedListsBinding.this.table.getTable().setEnabled(enable);
                for (AbstractCommand command : AbstractGlazedListsBinding.this.getCommands()) {
                    command.setEnabled(false);
                }
            }
        };
        JTable tableComponent = this.table.getTable();
        if (this.isEditSupported() && this.getEditCommand().isAuthorized()) {
            tableComponent.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(e)) {
                        AbstractGlazedListsBinding.this.edit(AbstractGlazedListsBinding.this.table.getSelectedRows());
                    }
                }
            });
        } else if (this.isShowDetailSupported() && this.getDetailCommand().isAuthorized()) {
            tableComponent.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1 && SwingUtilities.isLeftMouseButton(e)) {
                        AbstractGlazedListsBinding.this.showDetail(AbstractGlazedListsBinding.this.table.getSelectedRows());
                    }
                }
            });
        }
        editor.add((Component)this.table.getComponent(), "Center");
        List<AbstractCommand> commands = this.getCommands();
        if (commands != null && commands.size() > 0) {
            JPanel buttons = RcpSupport.createIconButtonPanel(commands);
            editor.add((Component)buttons, "South");
        }
        this.valueModelChanged(this.getValue());
        return editor;
    }

    protected TableWidget getTable() {
        if (this.table == null) {
            this.table = this.useOriginalSortOrder ? new GlazedListTableWidget(null, this.getTableDescription(), null) : new GlazedListTableWidget(null, this.getTableDescription());
        }
        return this.table;
    }

    public Object[] getSelection() {
        return this.table.getSelectedRows();
    }

    protected void readOnlyChanged() {
        for (AbstractCommand abstractCommand : this.getCommands()) {
            if (this.isShowDetailSupported() && abstractCommand == this.getDetailCommand()) {
                abstractCommand.setEnabled(this.isEnabled());
                continue;
            }
            abstractCommand.setEnabled(this.isEnabled() && !this.isReadOnly());
        }
    }

    protected void enabledChanged() {
        this.table.getTable().setEnabled(this.isEnabled());
        this.readOnlyChanged();
    }

    protected AbstractCommand createAddCommand() {
        ActionCommand addRow = new ActionCommand("addrow"){

            protected void doExecuteCommand() {
                AbstractGlazedListsBinding.this.add(AbstractGlazedListsBinding.this.viewControllerObject);
            }
        };
        addRow.setSecurityControllerId(this.getAddCommandSecurityControllerId());
        RcpSupport.configure(addRow);
        return addRow;
    }

    protected String getAddCommandSecurityControllerId() {
        return null;
    }

    protected AbstractCommand createRemoveCommand() {
        ActionCommand removeRow = new ActionCommand("removerow"){

            protected void doExecuteCommand() {
                AbstractGlazedListsBinding.this.remove(AbstractGlazedListsBinding.this.viewControllerObject, AbstractGlazedListsBinding.this.table.getSelectedRows());
            }
        };
        removeRow.setSecurityControllerId(this.getRemoveCommandSecurityControllerId());
        RcpSupport.configure(removeRow);
        return removeRow;
    }

    protected String getRemoveCommandSecurityControllerId() {
        return null;
    }

    protected AbstractCommand createDetailCommand() {
        ActionCommand detail = new ActionCommand("detailrow"){

            protected void doExecuteCommand() {
                Object[] selection = AbstractGlazedListsBinding.this.table.getSelectedRows();
                if (selection.length > 0) {
                    AbstractGlazedListsBinding.this.showDetail(selection);
                }
            }
        };
        RcpSupport.configure(detail);
        return detail;
    }

    protected AbstractCommand createEditCommand() {
        ActionCommand editRow = new ActionCommand("editrow"){

            protected void doExecuteCommand() {
                AbstractGlazedListsBinding.this.edit(AbstractGlazedListsBinding.this.table.getSelectedRows());
            }
        };
        editRow.setSecurityControllerId(this.getEditCommandSecurityControllerId());
        RcpSupport.configure(editRow);
        return editRow;
    }

    protected String getEditCommandSecurityControllerId() {
        return null;
    }

    public void edit(Object[] rows) {
        if (rows != null) {
            this.currentMode = 2;
            this.getOrCreateAddEditForm();
            for (Object row : rows) {
                this.form.setFormObject(row);
                this.getOrCreateFormDialog().showDialog();
            }
        }
    }

    protected void add(Object list) {
        this.currentMode = 1;
        this.getOrCreateAddEditForm().setFormObject(this.getNewFormObject());
        this.getOrCreateFormDialog().showDialog();
    }

    protected void remove(Object list, Object[] selection) {
        if (list instanceof Collection) {
            if (selection.length > 0) {
                ((Collection)list).removeAll(Arrays.asList(selection));
                this.listChanged();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void showDetail(Object[] rows) {
        if (rows != null) {
            this.getOrCreateDetailForm();
            for (Object row : rows) {
                this.detailForm.setFormObject(row);
                this.getOrCreateDetailFormDialog().showDialog();
            }
        }
    }

    protected AbstractForm getOrCreateAddEditForm() {
        if (this.form == null) {
            this.form = this.createAddEditForm();
        }
        return this.form;
    }

    protected AbstractForm getOrCreateDetailForm() {
        if (this.detailForm == null) {
            this.detailForm = this.createDetailForm();
        }
        return this.form;
    }

    protected AbstractForm createDetailForm() {
        throw new UnsupportedOperationException("Need a Form for adding/editing");
    }

    protected AbstractForm createAddEditForm() {
        throw new UnsupportedOperationException("Need a Form for adding/editing");
    }

    protected abstract TableDescription getTableDescription();

    protected Collection getList(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value == null) {
            return Collections.emptyList();
        }
        throw new IllegalArgumentException("getList 's argument is not a Collection: " + value.getClass());
    }

    protected Object getNewFormObject() {
        return null;
    }

    public void setDialogId(String dialogId) {
        this.dialogId = dialogId;
    }

    public String getDialogId() {
        if (this.dialogId == null) {
            return "listBindingDialog";
        }
        return this.dialogId;
    }

    private ApplicationDialog getOrCreateFormDialog() {
        if (this.formDialog == null) {
            this.formDialog = this.createFormDialog();
            this.formDialog.setParentComponent(this.table.getComponent());
            RcpSupport.configure(this.formDialog, this.getDialogId());
        }
        return this.formDialog;
    }

    private ApplicationDialog getOrCreateDetailFormDialog() {
        if (this.detailFormDialog == null) {
            this.detailFormDialog = this.createDetailFormDialog();
            this.detailFormDialog.setParentComponent(this.table.getComponent());
            RcpSupport.configure(this.detailFormDialog, this.getDialogId());
        }
        return this.detailFormDialog;
    }

    private ApplicationDialog createDetailFormDialog() {
        return new TitledApplicationDialog(){

            protected Object[] getCommandGroupMembers() {
                return new AbstractCommand[]{this.getFinishCommand()};
            }

            protected JComponent createTitledDialogContentPane() {
                return AbstractGlazedListsBinding.this.detailForm.getControl();
            }

            public void setTitle(String title) {
                super.setTitle(title);
                this.setTitlePaneTitle(title);
            }

            protected boolean onFinish() {
                return true;
            }
        };
    }

    private ApplicationDialog createFormDialog() {
        return new TitledApplicationDialog(){

            protected JComponent createTitledDialogContentPane() {
                AbstractGlazedListsBinding.this.form.newSingleLineResultsReporter(this);
                AbstractGlazedListsBinding.this.form.addGuarded(this);
                return AbstractGlazedListsBinding.this.form.getControl();
            }

            public void setTitle(String title) {
                super.setTitle(title);
                this.setTitlePaneTitle(title);
            }

            protected void onAboutToShow() {
                AbstractGlazedListsBinding.this.form.getFormModel().validate();
                if (AbstractGlazedListsBinding.this.form instanceof Focussable) {
                    ((AbstractFocussableForm)AbstractGlazedListsBinding.this.form).grabFocus();
                }
            }

            protected boolean onFinish() {
                if (AbstractGlazedListsBinding.this.form.hasErrors()) {
                    return false;
                }
                AbstractGlazedListsBinding.this.form.commit();
                final Object formObject = AbstractGlazedListsBinding.this.currentMode == 1 ? AbstractGlazedListsBinding.this.onFinishAdd(AbstractGlazedListsBinding.this.viewControllerObject, AbstractGlazedListsBinding.this.form.getFormObject()) : AbstractGlazedListsBinding.this.onFinishEdit(AbstractGlazedListsBinding.this.viewControllerObject, AbstractGlazedListsBinding.this.form.getFormObject());
                if (formObject != null) {
                    AbstractGlazedListsBinding.this.listChanged();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AbstractGlazedListsBinding.this.getTable().selectRowObject(formObject, null);
                        }
                    });
                }
                return formObject != null;
            }
        };
    }

    protected Object onFinishAdd(Object list, Object newItem) {
        if (list instanceof Collection) {
            ((Collection)list).add(newItem);
            return newItem;
        }
        throw new UnsupportedOperationException("onFinishAdd received a non Collection object, needs alternate implementation");
    }

    protected Object onFinishEdit(Object list, Object newItem) {
        return newItem;
    }
}

