/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.support.AbstractBinder;
import org.springframework.richclient.form.binding.swing.AbstractListBinding;
import org.springframework.rules.closure.Closure;
import org.springframework.rules.constraint.Constraint;
import org.springframework.util.Assert;

public abstract class AbstractListBinder
extends AbstractBinder {
    public static final String SELECTABLE_ITEMS_KEY = "selectableItems";
    public static final String COMPARATOR_KEY = "comparator";
    public static final String FILTER_KEY = "filter";
    private Object selectableItems;
    private Comparator comparator;
    private Constraint filter;

    public AbstractListBinder(Class requiredSourceClass) {
        this(requiredSourceClass, new String[]{SELECTABLE_ITEMS_KEY, COMPARATOR_KEY, FILTER_KEY});
    }

    public AbstractListBinder(Class requiredSourceClass, String[] supportedContextKeys) {
        super(requiredSourceClass, supportedContextKeys);
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public Constraint getFilter() {
        return this.filter;
    }

    public void setFilter(Constraint filter) {
        this.filter = filter;
    }

    public Object getSelectableItems() {
        return this.selectableItems;
    }

    public void setSelectableItems(Object selectableItems) {
        this.selectableItems = selectableItems;
    }

    protected final Binding doBind(JComponent control, FormModel formModel, String formPropertyPath, Map context) {
        AbstractListBinding binding = this.createListBinding(control, formModel, formPropertyPath);
        Assert.notNull((Object)binding);
        this.applyContext(binding, context);
        return binding;
    }

    protected abstract AbstractListBinding createListBinding(JComponent var1, FormModel var2, String var3);

    protected void applyContext(AbstractListBinding binding, Map context) {
        if (context.containsKey(SELECTABLE_ITEMS_KEY)) {
            binding.setSelectableItems(this.decorate(context.get(SELECTABLE_ITEMS_KEY), this.selectableItems));
        } else if (this.selectableItems != null) {
            binding.setSelectableItems(this.selectableItems);
        }
        if (context.containsKey(COMPARATOR_KEY)) {
            binding.setComparator((Comparator)this.decorate(context.get(COMPARATOR_KEY), this.comparator));
        } else if (this.comparator != null) {
            binding.setComparator(this.comparator);
        }
        if (context.containsKey(FILTER_KEY)) {
            binding.setFilter((Constraint)this.decorate(context.get(FILTER_KEY), this.filter));
        } else if (this.filter != null) {
            binding.setFilter(this.filter);
        }
    }

    protected Object decorate(Object closure, Object object) {
        if (closure instanceof Closure) {
            return ((Closure)closure).call(object);
        }
        return closure;
    }
}

