/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.value.ValueModel;
import org.springframework.core.ReflectiveVisitorHelper;
import org.springframework.richclient.form.binding.support.AbstractBinding;
import org.springframework.richclient.list.AbstractFilteredListModel;
import org.springframework.richclient.list.FilteredListModel;
import org.springframework.richclient.list.SortedListModel;
import org.springframework.rules.constraint.Constraint;
import org.springframework.util.Assert;

public abstract class AbstractListBinding
extends AbstractBinding {
    private JComponent component;
    final ReflectiveVisitorHelper visitorHelper = new ReflectiveVisitorHelper();
    private final SelectableItemsVisitor selectableItemsVisitor = new SelectableItemsVisitor();
    private Object selectableItems;
    private final FilterConstraint filterConstraint = new FilterConstraint();
    private final BindingComparator bindingComparator = new BindingComparator();
    private ListModel bindingModel;
    private AbstractFilteredListModel filteredModel;

    public AbstractListBinding(JComponent component, FormModel formModel, String formPropertyPath, Class requiredSourceClass) {
        super(formModel, formPropertyPath, requiredSourceClass);
        this.component = component;
    }

    protected void enabledChanged() {
        this.component.setEnabled(!this.isReadOnly() && this.isEnabled());
    }

    protected void readOnlyChanged() {
        this.enabledChanged();
    }

    public Object getSelectableItems() {
        return this.selectableItems;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public final void setSelectableItems(Object selectableItems) {
        Assert.notNull((Object)selectableItems);
        if (!selectableItems.equals(this.selectableItems)) {
            this.selectableItems = selectableItems;
            this.selectableItemsChanged();
        }
    }

    public final void setComparator(Comparator comparator) {
        this.bindingComparator.setComparator(comparator);
    }

    public Comparator getComparator() {
        return this.bindingComparator.getComparator();
    }

    public final void setFilter(Constraint filter) {
        this.filterConstraint.setFilter(filter);
    }

    protected final JComponent doBindControl() {
        this.doBindControl(this.getBindingModel());
        return this.getComponent();
    }

    protected abstract void doBindControl(ListModel var1);

    protected void selectableItemsChanged() {
        if (this.filteredModel != null) {
            this.filteredModel.setFilteredModel(this.createModel());
        }
    }

    protected ListModel createModel() {
        return (ListModel)this.visitorHelper.invokeVisit((Object)this.selectableItemsVisitor, this.selectableItems);
    }

    protected AbstractFilteredListModel getFilteredModel() {
        if (this.filteredModel == null) {
            this.filteredModel = this.createFilteredModel(this.createModel(), this.filterConstraint);
        }
        return this.filteredModel;
    }

    protected ListModel getBindingModel() {
        if (this.bindingModel == null) {
            this.bindingModel = this.createSortedListModel(this.getFilteredModel(), this.bindingComparator);
        }
        return this.bindingModel;
    }

    protected ListModel createSortedListModel(ListModel listModel, Comparator comparator) {
        return new SortedListModel(listModel, comparator);
    }

    protected AbstractFilteredListModel createFilteredModel(ListModel model, Constraint constraint) {
        return new FilteredListModel(model, constraint);
    }

    protected Object convertValue(Object value, Class targetClass) throws ConversionException {
        Assert.notNull((Object)value);
        Assert.notNull((Object)targetClass);
        return this.getConversionService().getConversionExecutor(value.getClass(), targetClass).execute(value);
    }

    protected abstract ListModel getDefaultModel();

    public Constraint getFilter() {
        return this.filterConstraint.getFilter();
    }

    class BindingComparator
    extends Observable
    implements Comparator,
    Observer {
        private Comparator comparator;

        BindingComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (this.comparator != null) {
                return this.comparator.compare(o1, o2);
            }
            return 0;
        }

        public void setComparator(Comparator comparator) {
            if (comparator != this.comparator || comparator != null && !((Object)comparator).equals(this.comparator)) {
                if (this.comparator instanceof Observable) {
                    ((Observable)((Object)this.comparator)).deleteObserver(this);
                }
                this.comparator = comparator;
                if (comparator instanceof Observable) {
                    ((Observable)((Object)this.comparator)).addObserver(this);
                }
                this.update();
            }
        }

        public Comparator getComparator() {
            return this.comparator;
        }

        void update() {
            this.setChanged();
            this.notifyObservers();
        }

        public void update(Observable o, Object arg) {
            this.update();
        }
    }

    class FilterConstraint
    extends Observable
    implements Constraint,
    Observer {
        private Constraint filter;

        FilterConstraint() {
        }

        public boolean test(Object argument) {
            if (this.filter != null) {
                return this.filter.test(argument);
            }
            return true;
        }

        public Constraint getFilter() {
            return this.filter;
        }

        public void setFilter(Constraint filter) {
            if (filter != this.filter || filter != null && !filter.equals(this.filter)) {
                if (this.filter instanceof Observable) {
                    ((Observable)((Object)this.filter)).deleteObserver(this);
                }
                this.filter = filter;
                if (filter instanceof Observable) {
                    ((Observable)((Object)this.filter)).addObserver(this);
                }
                this.update();
            }
        }

        public void update() {
            this.setChanged();
            this.notifyObservers();
        }

        public void update(Observable o, Object arg) {
            this.update();
        }
    }

    class ValueModelFilteredListModel
    extends AbstractFilteredListModel
    implements PropertyChangeListener {
        private final ValueModel valueModel;

        public ValueModelFilteredListModel(ListModel model, ValueModel valueModel) {
            super(model);
            this.valueModel = valueModel;
            valueModel.addValueChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.setFilteredModel((ListModel)AbstractListBinding.this.visitorHelper.invokeVisit((Object)AbstractListBinding.this.selectableItemsVisitor, this.valueModel.getValue()));
        }
    }

    class SelectableItemsVisitor {
        SelectableItemsVisitor() {
        }

        ListModel visit(ValueModel valueModel) {
            Assert.notNull((Object)valueModel.getValue(), (String)"value of ValueModel must not be null. Use an empty Collection or Array");
            ListModel model = (ListModel)AbstractListBinding.this.visitorHelper.invokeVisit((Object)this, valueModel.getValue());
            return new ValueModelFilteredListModel(model, valueModel);
        }

        ListModel visit(Object object) {
            return (ListModel)AbstractListBinding.this.convertValue(object, ListModel.class);
        }

        ListModel visitNull() {
            return AbstractListBinding.this.getDefaultModel();
        }
    }
}

