/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.components.FileChooser;
import org.springframework.richclient.form.binding.support.CustomBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChooserBinding
extends CustomBinding {
    private final FileChooser field;
    private final boolean useFile;

    public FileChooserBinding(FormModel model, String path, Class<?> class1, FileChooser field, FileChooser.FileChooserMode mode, boolean useFile) {
        super(model, path, class1);
        this.field = field;
        this.field.setMode(mode);
        this.useFile = useFile;
    }

    @Override
    protected void valueModelChanged(Object newValue) {
        if (!this.useFile) {
            this.field.setText((String)newValue);
        } else {
            this.field.setText(((File)newValue).getAbsolutePath());
        }
        this.readOnlyChanged();
    }

    @Override
    protected JComponent doBindControl() {
        if (!this.useFile && this.getValue() != null) {
            this.field.setText((String)this.getValue());
        } else if (this.useFile && this.getValue() != null) {
            this.field.setText(((File)this.getValue()).getAbsolutePath());
        } else {
            this.field.setText("");
        }
        this.field.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (FileChooserBinding.this.field.isEditable()) {
                    if (FileChooserBinding.this.useFile) {
                        FileChooserBinding.this.controlValueChanged(new File(FileChooserBinding.this.field.getText()));
                    } else {
                        FileChooserBinding.this.controlValueChanged(FileChooserBinding.this.field.getText());
                    }
                }
            }
        });
        return this.field;
    }

    @Override
    protected void readOnlyChanged() {
        this.field.setEditable(this.isEnabled() && !this.isReadOnly());
    }

    @Override
    protected void enabledChanged() {
        this.field.setEnabled(this.isEnabled());
        this.readOnlyChanged();
    }
}

