/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.ListModel;
import org.springframework.binding.form.FormModel;
import org.springframework.context.MessageSource;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.form.binding.swing.ComboBoxBinding;
import org.springframework.richclient.list.LabeledEnumComboBoxEditor;
import org.springframework.richclient.list.LabeledEnumListRenderer;
import org.springframework.util.comparator.ComparableComparator;
import org.springframework.util.comparator.CompoundComparator;

public class LabeledEnumComboBoxBinding
extends ComboBoxBinding {
    private MessageSource messageSource;

    public LabeledEnumComboBoxBinding(JComboBox comboBox, FormModel formModel, String formPropertyPath) {
        super(comboBox, formModel, formPropertyPath);
    }

    protected void doBindControl(ListModel bindingModel) {
        this.setRenderer(new LabeledEnumListRenderer(this.getMessageSource()));
        this.setEditor(new LabeledEnumComboBoxEditor(this.getMessageSource(), this.getEditor()));
        CompoundComparator comparator = new CompoundComparator();
        comparator.addComparator(LabeledEnum.LABEL_ORDER);
        comparator.addComparator((Comparator)new ComparableComparator());
        this.setComparator((Comparator)comparator);
        super.doBindControl(bindingModel);
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    protected MessageSource getMessageSource() {
        if (this.messageSource == null) {
            this.messageSource = (MessageSource)ApplicationServicesLocator.services().getService(MessageSource.class);
        }
        return this.messageSource;
    }
}

