/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.BufferedCollectionValueModel;
import org.springframework.binding.value.support.ListListModel;
import org.springframework.context.MessageSource;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.components.ShuttleList;
import org.springframework.richclient.form.binding.support.AbstractBinding;
import org.springframework.richclient.image.IconSource;
import org.springframework.richclient.list.DynamicListModel;

public class ShuttleListBinding
extends AbstractBinding {
    private ShuttleList list;
    private ListModel model;
    private ValueModel selectedItemsHolder = null;
    private ValueModel selectableItemsHolder;
    private Comparator comparator;
    private Class selectedItemType;
    private Class concreteSelectedType;
    private String formId;

    public ShuttleListBinding(ShuttleList list, FormModel formModel, String formPropertyPath) {
        super(formModel, formPropertyPath, null);
        this.list = list;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public void setModel(ListModel model) {
        this.model = model;
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.list.setCellRenderer(renderer);
    }

    public ListCellRenderer getRenderer() {
        return this.list.getCellRenderer();
    }

    public void setSelectableItemsHolder(ValueModel selectableItemsHolder) {
        this.selectableItemsHolder = selectableItemsHolder;
    }

    public void setSelectedItemsHolder(ValueModel selectedItemsHolder) {
        this.selectedItemsHolder = selectedItemsHolder;
    }

    public void setSelectedItemType(Class selectedItemType) {
        this.selectedItemType = selectedItemType;
    }

    protected Class getSelectedItemType() {
        if (this.selectedItemType == null && this.selectedItemsHolder != null && this.selectedItemsHolder.getValue() != null) {
            this.setSelectedItemType(this.selectedItemsHolder.getValue().getClass());
        }
        return this.selectedItemType;
    }

    protected JComponent doBindControl() {
        this.list.setModel(this.createModel());
        if (this.selectedItemsHolder != null) {
            this.setSelectedValue(null);
            this.list.addListSelectionListener(new ListSelectedValueMediator());
        }
        if (this.comparator != null) {
            this.list.setComparator(this.comparator);
        }
        this.list.setEditIcon(this.getEditIcon(), this.getEditIconText());
        this.list.setListLabels(this.getChosenLabel(), this.getSourceLabel());
        return this.list;
    }

    private String getSourceLabel() {
        return this.getMsgText("shuttleList.sourceList.label", null);
    }

    private String getChosenLabel() {
        return this.getMsgText("shuttleList.chosenList.label", null);
    }

    private String getEditIconText() {
        return this.getMsgText("shuttleList.editText", "Edit...");
    }

    private String getMsgText(String key, String defaultMsg) {
        MessageSource messageSource = (MessageSource)ApplicationServicesLocator.services().getService(MessageSource.class);
        String text = null;
        if (this.getFormId() != null) {
            if (this.getProperty() != null) {
                text = messageSource.getMessage(this.getFormId() + "." + this.getProperty() + "." + key, null, null, null);
            }
            if (text == null) {
                text = messageSource.getMessage(this.getFormId() + "." + key, null, null, null);
            }
        }
        if (text == null) {
            text = messageSource.getMessage(key, null, defaultMsg, null);
        }
        return text;
    }

    private Icon getEditIcon() {
        IconSource iconSource = (IconSource)ApplicationServicesLocator.services().getService(IconSource.class);
        Icon icon = null;
        if (this.getFormId() != null) {
            icon = iconSource.getIcon(this.getFormId() + ".shuttleList.edit");
        }
        if (icon == null) {
            icon = iconSource.getIcon("shuttleList.edit");
        }
        return icon;
    }

    protected boolean isSelectedItemAnArray() {
        Class itemType = this.getSelectedItemType();
        return itemType != null && itemType.isArray();
    }

    protected boolean isSelectedItemACollection() {
        return this.getSelectedItemType() != null && Collection.class.isAssignableFrom(this.getSelectedItemType());
    }

    protected Class getConcreteSelectedType() {
        if (this.concreteSelectedType == null) {
            if (this.isSelectedItemACollection()) {
                this.concreteSelectedType = BufferedCollectionValueModel.getConcreteCollectionType(this.getSelectedItemType());
            } else if (this.isSelectedItemAnArray()) {
                this.concreteSelectedType = this.getSelectedItemType().getComponentType();
            }
        }
        return this.concreteSelectedType;
    }

    protected void setSelectedValue(PropertyChangeListener silentValueChangeHandler) {
        int[] indices = this.indicesOf(this.selectedItemsHolder.getValue());
        if (indices.length < 1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndices(indices);
            this.updateSelectionHolderFromList(silentValueChangeHandler);
        }
    }

    protected int[] indicesOf(Object itemSet) {
        int[] ret = null;
        if (itemSet instanceof Collection) {
            Collection collection = (Collection)itemSet;
            ret = new int[collection.size()];
            int i = 0;
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                ret[i] = this.indexOf(iter.next());
                ++i;
            }
        } else if (itemSet == null) {
            ret = new int[]{};
        } else if (itemSet.getClass().isArray()) {
            Object[] items = (Object[])itemSet;
            ret = new int[items.length];
            for (int i = 0; i < items.length; ++i) {
                ret[i] = this.indexOf(items[i]);
            }
        } else {
            throw new IllegalArgumentException("itemSet must be eithe an Array or a Collection");
        }
        return ret;
    }

    protected int indexOf(Object o) {
        ListModel listModel = this.list.getModel();
        int size = listModel.getSize();
        for (int i = 0; i < size; ++i) {
            if (!this.equalByComparator(o, listModel.getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    private ListModel createModel() {
        if (this.model != null) {
            return this.model;
        }
        ListListModel model = this.selectableItemsHolder != null ? new DynamicListModel(this.selectableItemsHolder) : new ListListModel();
        model.setComparator(this.comparator);
        model.sort();
        return model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateSelectionHolderFromList(PropertyChangeListener silentValueChangeHandler) {
        Object[] selected = this.list.getSelectedValues();
        if (this.isSelectedItemACollection()) {
            try {
                Collection oldSelection;
                Collection newSelection = (Collection)this.getConcreteSelectedType().newInstance();
                if (selected != null && selected.length > 0) {
                    for (int i = 0; i < selected.length; ++i) {
                        newSelection.add(selected[i]);
                    }
                }
                if ((oldSelection = (Collection)this.selectedItemsHolder.getValue()) != null && oldSelection.size() == newSelection.size() && this.collectionsEqual(oldSelection, newSelection)) return;
                if (silentValueChangeHandler != null) {
                    this.selectedItemsHolder.setValueSilently(newSelection, silentValueChangeHandler);
                    return;
                }
                this.selectedItemsHolder.setValue(newSelection);
                return;
            }
            catch (InstantiationException e1) {
                throw new RuntimeException("Unable to instantiate new concrete collection class for new selection.", e1);
            }
            catch (IllegalAccessException e1) {
                throw new RuntimeException(e1);
            }
        } else {
            if (!this.isSelectedItemAnArray()) return;
            Object[] newSelection = (Object[])Array.newInstance(this.getConcreteSelectedType(), selected.length);
            for (int i = 0; i < selected.length; ++i) {
                newSelection[i] = selected[i];
            }
            Object[] oldSelection = (Object[])this.selectedItemsHolder.getValue();
            if (oldSelection != null && oldSelection.length == newSelection.length && this.arraysEqual(oldSelection, newSelection)) return;
            if (silentValueChangeHandler != null) {
                this.selectedItemsHolder.setValueSilently(newSelection, silentValueChangeHandler);
                return;
            } else {
                this.selectedItemsHolder.setValue(newSelection);
            }
        }
    }

    protected boolean arraysEqual(Object[] a1, Object[] a2) {
        if (a1 != null && a2 != null && a1.length == a2.length) {
            for (int i = 0; i < a1.length; ++i) {
                if (this.equalByComparator(a1[i], a2[i])) continue;
                return false;
            }
            return true;
        }
        return a1 == null && a2 == null;
    }

    protected boolean collectionsEqual(Collection a1, Collection a2) {
        if (a1 != null && a2 != null && a1.size() == a2.size()) {
            Iterator iterA1 = a1.iterator();
            Iterator iterA2 = a2.iterator();
            while (iterA1.hasNext()) {
                if (this.equalByComparator(iterA1.next(), iterA2.next())) continue;
                return false;
            }
        } else if (a1 == null && a2 == null) {
            return true;
        }
        return false;
    }

    private boolean equalByComparator(Object o1, Object o2) {
        return this.comparator == null ? o1.equals(o2) : this.comparator.compare(o1, o2) == 0;
    }

    protected void readOnlyChanged() {
        this.list.setEnabled(this.isEnabled() && !this.isReadOnly());
    }

    protected void enabledChanged() {
        this.list.setEnabled(this.isEnabled() && !this.isReadOnly());
    }

    protected String getFormId() {
        return this.formId;
    }

    protected void setFormId(String formId) {
        this.formId = formId;
    }

    private class ListSelectedValueMediator
    implements ListSelectionListener {
        private final PropertyChangeListener valueChangeHandler;

        public ListSelectedValueMediator() {
            this.valueChangeHandler = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ShuttleListBinding.this.setSelectedValue(ListSelectedValueMediator.this.valueChangeHandler);
                }
            };
            ShuttleListBinding.this.selectedItemsHolder.addValueChangeListener(this.valueChangeHandler);
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ShuttleListBinding.this.updateSelectionHolderFromList(this.valueChangeHandler);
            }
        }
    }
}

