/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.components.SliderLabelFactory;
import org.springframework.richclient.form.binding.support.CustomBinding;

public class SliderBinding
extends CustomBinding {
    private JSlider slider = new JSlider();
    private boolean readOnly;
    private SliderLabelFactory sliderLabelFactory;
    private int maxSpacing;

    public SliderBinding(FormModel formModel, String formPropertyPath) {
        super(formModel, formPropertyPath, Integer.class);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SliderBinding.this.controlValueChanged(SliderBinding.this.slider.getValue());
            }
        });
    }

    protected void valueModelChanged(Object newValue) {
        this.slider.setValue((Integer)newValue);
        this.readOnlyChanged();
    }

    protected JComponent doBindControl() {
        if (this.sliderLabelFactory == null) {
            this.slider.createStandardLabels(this.maxSpacing);
        } else {
            this.slider.setLabelTable(this.sliderLabelFactory.getSliderLabels());
        }
        this.slider.setPaintLabels(true);
        this.slider.setValue((Integer)this.getValue());
        return this.slider;
    }

    protected void enabledChanged() {
        this.slider.setEnabled(this.isEnabled());
        this.readOnlyChanged();
    }

    protected void readOnlyChanged() {
        this.slider.setEnabled(this.isEnabled() && !this.isReadOnly() && !this.readOnly);
    }

    public void setMaxValue(int maxValue) {
        this.slider.setMaximum(maxValue);
    }

    public void setMinValue(int minValue) {
        this.slider.setMinimum(minValue);
    }

    public void setMajorTickSpacing(int spacing) {
        this.maxSpacing = spacing;
        this.slider.setMajorTickSpacing(spacing);
    }

    public void setMinorTickSpacing(int spacing) {
        this.slider.setMinorTickSpacing(spacing);
    }

    public void setSliderLabelFactory(SliderLabelFactory sliderLabelFactory) {
        this.sliderLabelFactory = sliderLabelFactory;
    }
}

