/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.support.CustomBinding;

public class SpinnerBinding
extends CustomBinding
implements ChangeListener {
    private final JSpinner spinner;

    public SpinnerBinding(FormModel formModel, String propertyPath, Class numberClass, JSpinner spinner) {
        super(formModel, propertyPath, numberClass);
        this.spinner = spinner;
    }

    protected JComponent doBindControl() {
        this.spinner.setValue(this.getValue());
        this.spinner.getModel().addChangeListener(this);
        return this.spinner;
    }

    protected void readOnlyChanged() {
        this.spinner.setEnabled(!this.isReadOnly() && this.isEnabled());
    }

    protected void enabledChanged() {
        this.readOnlyChanged();
    }

    public void stateChanged(ChangeEvent e) {
        this.controlValueChanged(this.spinner.getValue());
    }

    protected void valueModelChanged(Object newValue) {
        this.spinner.setValue(newValue);
    }
}

