/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.support.CustomBinding;

public class ToggleButtonBinding
extends CustomBinding {
    private final JToggleButton toggleButton;
    private ItemListener selectionListener = new SelectionListener();
    private boolean configureFace = true;

    public ToggleButtonBinding(JToggleButton toggleButton, FormModel formModel, String formPropertyPath) {
        super(formModel, formPropertyPath, Boolean.class);
        this.toggleButton = toggleButton;
    }

    protected JComponent doBindControl() {
        if (this.configureFace) {
            this.getFieldFace().configure(this.toggleButton);
        }
        this.toggleButton.getModel().addItemListener(this.selectionListener);
        this.toggleButton.setSelected(Boolean.TRUE.equals(this.getValue()));
        return this.toggleButton;
    }

    void setConfigureFace(boolean configureFace) {
        this.configureFace = configureFace;
    }

    protected void readOnlyChanged() {
        this.toggleButton.setEnabled(this.isEnabled() && !this.isReadOnly());
    }

    protected void enabledChanged() {
        this.toggleButton.setEnabled(this.isEnabled() && !this.isReadOnly());
    }

    protected void valueModelChanged(Object newValue) {
        this.toggleButton.setSelected(Boolean.TRUE.equals(newValue));
    }

    protected class SelectionListener
    implements ItemListener {
        protected SelectionListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ToggleButtonBinding.this.controlValueChanged(ToggleButtonBinding.this.toggleButton.isSelected());
        }
    }
}

