/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing.editor;

import java.util.Map;
import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.Binder;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.swing.editor.AbstractLookupBinding;
import org.springframework.richclient.util.RcpSupport;
import org.springframework.richclient.widget.editor.DefaultDataEditorWidget;
import org.springframework.util.Assert;

public abstract class AbstractLookupBinder
implements Binder {
    private int autoPopupDialog = 6;
    private boolean revertValueOnFocusLost = true;
    private String selectDialogId = "foreignKeySelectDialog";
    private String selectDialogCommandId = "foreignKeyPropertyEditorCommand";
    private final String dataEditorId;
    private String dataEditorViewCommandId;
    private Object filter;
    private boolean enableViewCommand;
    private boolean loadDetailedObject = false;

    public boolean isLoadDetailedObject() {
        return this.loadDetailedObject;
    }

    public void setLoadDetailedObject(boolean loadDetailedObject) {
        this.loadDetailedObject = loadDetailedObject;
    }

    public AbstractLookupBinder(String dataEditorId) {
        this.dataEditorId = dataEditorId;
        this.enableViewCommand = false;
    }

    public void setAutoPopupDialog(int autoPopupDialog) {
        this.autoPopupDialog = autoPopupDialog;
    }

    public void setRevertValueOnFocusLost(boolean revertValueOnFocusLost) {
        this.revertValueOnFocusLost = revertValueOnFocusLost;
    }

    public void setSelectDialogId(String selectDialogId) {
        this.selectDialogId = selectDialogId;
    }

    public void setSelectDialogCommandId(String selectDialogCommandId) {
        this.selectDialogCommandId = selectDialogCommandId;
    }

    public Binding bind(FormModel formModel, String formPropertyPath, Map context) {
        AbstractLookupBinding referableBinding = this.getLookupBinding(formModel, formPropertyPath, context);
        referableBinding.setAutoPopupdialog(this.getAutoPopupDialog());
        referableBinding.setRevertValueOnFocusLost(this.isRevertValueOnFocusLost());
        referableBinding.setSelectDialogCommandId(this.getSelectDialogCommandId());
        referableBinding.setSelectDialogId(this.getSelectDialogId());
        referableBinding.setDataEditorViewCommandId(this.dataEditorViewCommandId);
        referableBinding.setEnableViewCommand(this.enableViewCommand);
        referableBinding.setFilter(this.filter);
        referableBinding.setLoadDetailedObject(this.loadDetailedObject);
        return referableBinding;
    }

    protected abstract AbstractLookupBinding getLookupBinding(FormModel var1, String var2, Map var3);

    public Binding bind(JComponent control, FormModel formModel, String formPropertyPath, Map context) {
        throw new UnsupportedOperationException("This binder needs a special component that cannot be given");
    }

    protected int getAutoPopupDialog() {
        return this.autoPopupDialog;
    }

    protected DefaultDataEditorWidget getDataEditor() {
        Object dataEditor = RcpSupport.getBean(this.dataEditorId);
        Assert.isInstanceOf(DefaultDataEditorWidget.class, dataEditor);
        return (DefaultDataEditorWidget)dataEditor;
    }

    protected boolean isRevertValueOnFocusLost() {
        return this.revertValueOnFocusLost;
    }

    protected String getSelectDialogCommandId() {
        return this.selectDialogCommandId;
    }

    protected String getSelectDialogId() {
        return this.selectDialogId;
    }

    public void setDataEditorViewCommandId(String dataEditorViewCommandId) {
        this.dataEditorViewCommandId = dataEditorViewCommandId;
    }

    public void setEnableViewCommand(boolean enableViewCommand) {
        this.enableViewCommand = enableViewCommand;
    }

    public void setFilter(Object filter) {
        this.filter = filter;
    }

    public String getDataEditorViewCommandId() {
        return this.dataEditorViewCommandId;
    }

    public Object getFilter() {
        return this.filter;
    }

    public boolean isEnableViewCommand() {
        return this.enableViewCommand;
    }
}

