/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing.editor;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.support.DataEditorWidgetViewCommand;
import org.springframework.richclient.components.PanelWithValidationComponent;
import org.springframework.richclient.dialog.ApplicationDialog;
import org.springframework.richclient.dialog.TitledWidgetApplicationDialog;
import org.springframework.richclient.form.binding.support.CustomBinding;
import org.springframework.richclient.text.SelectAllFocusListener;
import org.springframework.richclient.util.Assert;
import org.springframework.richclient.util.RcpSupport;
import org.springframework.richclient.widget.editor.DefaultDataEditorWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLookupBinding
extends CustomBinding {
    public static final String ON_ABOUT_TO_CHANGE = "on-about-to-change";
    public static final String NO_INITIALIZE_DATA_EDITOR = "no-initialize-dataeditor";
    public static final int AUTOPOPUPDIALOG_UNIQUE_MATCH = 1;
    public static final int AUTOPOPUPDIALOG_NO_MATCH = 2;
    public static final int AUTOPOPUPDIALOG_MULTIPLE_MATCH = 4;
    public static final int AUTOPOPUPDIALOG_ALWAYS = 7;
    public static final int AUTOPOPUPDIALOG_NO_UNIQUE_MATCH = 6;
    private int autoPopupDialog = 6;
    public static final Boolean ON = Boolean.TRUE;
    public static final Boolean OFF = Boolean.FALSE;
    public static final String DEFAULT_SELECTDIALOG_ID = "foreignKeySelectDialog";
    public static final String DEFAULT_SELECTDIALOG_COMMAND_ID = "foreignKeyPropertyEditorCommand";
    private final DefaultDataEditorWidget dataEditor;
    private boolean revertValueOnFocusLost = true;
    private String selectDialogId = "foreignKeySelectDialog";
    private String selectDialogCommandId = "foreignKeyPropertyEditorCommand";
    private final Map<Object, Object> parameters;
    private AbstractButton dataEditorButton;
    private ActionCommand dataEditorCommand;
    private JComponent keyField;
    private PropertyChangeMonitor propertyChangeMonitor = new PropertyChangeMonitor();
    private String dataEditorViewCommandId;
    private boolean enableViewCommand = false;
    private ReferableDataEditorViewCommand referableDataEditorViewCommand;
    private boolean loadDetailedObject = false;
    private Object filter;

    public AbstractLookupBinding(DefaultDataEditorWidget dataEditor, FormModel formModel, String formPropertyPath) {
        super(formModel, formPropertyPath, null);
        this.dataEditor = dataEditor;
        this.parameters = new HashMap<Object, Object>();
        this.parameters.put(NO_INITIALIZE_DATA_EDITOR, ON);
        this.referableDataEditorViewCommand = new ReferableDataEditorViewCommand();
        formModel.getValueModel(formPropertyPath).addValueChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AbstractLookupBinding.this.referableDataEditorViewCommand.setEnabled(evt.getNewValue() != null);
                if (evt.getNewValue() != null) {
                    AbstractLookupBinding.this.referableDataEditorViewCommand.setSelectedObject(evt.getNewValue());
                }
            }
        });
    }

    protected Map<Object, Object> getParameters() {
        return this.parameters;
    }

    protected String getSelectDialogId() {
        return this.selectDialogId;
    }

    public void setSelectDialogId(String selectDialogId) {
        this.selectDialogId = selectDialogId;
    }

    protected String getSelectDialogCommandId() {
        return this.selectDialogCommandId;
    }

    public void setSelectDialogCommandId(String selectDialogCommandId) {
        this.selectDialogCommandId = selectDialogCommandId;
    }

    protected int getAutoPopupDialog() {
        return this.autoPopupDialog;
    }

    public void setAutoPopupdialog(int autoPopupDialog) {
        this.autoPopupDialog = autoPopupDialog;
    }

    protected boolean revertValueOnFocusLost() {
        return this.revertValueOnFocusLost;
    }

    public void setRevertValueOnFocusLost(boolean revertValueOnFocusLost) {
        this.revertValueOnFocusLost = revertValueOnFocusLost;
    }

    @Override
    protected void valueModelChanged(Object newValue) {
        if (newValue == null) {
            this.setKeyComponentText(null);
        } else {
            this.setKeyComponentText(this.getObjectLabel(newValue));
        }
        this.readOnlyChanged();
    }

    public abstract String getObjectLabel(Object var1);

    @Override
    protected JComponent doBindControl() {
        FormLayout layout = this.isEnableViewCommand() ? new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.MINIMUM, 0.0), FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.MINIMUM, 0.0)}, new RowSpec[]{new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}) : new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.RELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.MINIMUM, 0.0)}, new RowSpec[]{new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0)});
        PanelWithValidationComponent editor = new PanelWithValidationComponent((LayoutManager)layout){
            private static final long serialVersionUID = 534852878664152460L;

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                AbstractLookupBinding.this.getKeyComponent().setEnabled(enabled);
                AbstractLookupBinding.this.getDataEditorCommand().setEnabled(enabled);
            }

            public JComponent getValidationComponent() {
                return AbstractLookupBinding.this.getKeyComponent();
            }

            public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
                AbstractLookupBinding.this.propertyChangeMonitor.addVetoableChangeListener(listener);
            }

            public boolean requestFocusInWindow() {
                return AbstractLookupBinding.this.getKeyComponent().requestFocusInWindow();
            }
        };
        CellConstraints cc = new CellConstraints();
        editor.add((Component)this.getKeyComponent(), cc.xy(1, 1));
        editor.add((Component)this.getDataEditorButton(), cc.xy(3, 1));
        if (this.isEnableViewCommand()) {
            AbstractButton viewButton = this.referableDataEditorViewCommand.createButton();
            viewButton.setFocusable(false);
            editor.add((Component)viewButton, cc.xy(5, 1));
        }
        this.valueModelChanged(this.getValue());
        return editor;
    }

    @Deprecated
    protected JTextComponent getOrCreateKeyTextComponent() {
        return (JTextComponent)this.getKeyComponent();
    }

    protected JComponent getKeyComponent() {
        if (this.keyField == null) {
            this.keyField = this.createKeyComponent();
        }
        return this.keyField;
    }

    protected JComponent createKeyComponent() {
        return this.createTextComponent();
    }

    @Deprecated
    protected JTextField createTextComponent() {
        JTextField textField = new JTextField();
        textField.setFocusTraversalKeys(0, new HashSet());
        textField.addKeyListener(this.createKeyListener());
        textField.addFocusListener(new SelectAllFocusListener(textField));
        textField.addFocusListener(this.createFocusListener());
        return textField;
    }

    protected String getKeyComponentText() {
        if (this.getKeyComponent() instanceof JTextComponent) {
            return ((JTextComponent)this.getKeyComponent()).getText();
        }
        return "";
    }

    protected void setKeyComponentText(String text) {
        if (this.getKeyComponent() instanceof JTextComponent) {
            ((JTextComponent)this.getKeyComponent()).setText(text);
        }
    }

    protected TabKeyListener createKeyListener() {
        return new TabKeyListener(){

            public void onTabKey(Component component) {
                String textFieldValue = AbstractLookupBinding.this.getKeyComponentText();
                boolean empty = "".equals(textFieldValue.trim());
                Object ref = AbstractLookupBinding.this.getValue();
                if (!(empty || ref != null && textFieldValue.equals(AbstractLookupBinding.this.getObjectLabel(ref)))) {
                    Object result = AbstractLookupBinding.this.initializeDataEditor();
                    if (result == null) {
                        if (!AbstractLookupBinding.this.revertValueOnFocusLost()) {
                            AbstractLookupBinding.this.getValueModel().setValue(AbstractLookupBinding.this.createFilterFromString(textFieldValue));
                        }
                        if ((AbstractLookupBinding.this.getAutoPopupDialog() & 2) == 2) {
                            AbstractLookupBinding.this.getDataEditorCommand().execute(AbstractLookupBinding.this.parameters);
                        }
                    } else if (result instanceof List && ((List)result).size() > 1) {
                        if (!AbstractLookupBinding.this.revertValueOnFocusLost()) {
                            AbstractLookupBinding.this.getValueModel().setValue(AbstractLookupBinding.this.createFilterFromString(textFieldValue));
                        }
                        if ((AbstractLookupBinding.this.getAutoPopupDialog() & 4) == 4) {
                            AbstractLookupBinding.this.getDataEditorCommand().execute(AbstractLookupBinding.this.parameters);
                        }
                    } else {
                        AbstractLookupBinding.this.setValue(result, true);
                        if ((AbstractLookupBinding.this.getAutoPopupDialog() & 1) == 1) {
                            AbstractLookupBinding.this.getDataEditorCommand().execute(AbstractLookupBinding.this.parameters);
                        }
                    }
                } else if (!AbstractLookupBinding.this.revertValueOnFocusLost() && empty && ref != null) {
                    AbstractLookupBinding.this.getValueModel().setValue(null);
                }
                AbstractLookupBinding.this.getDataEditorButton().transferFocus();
            }
        };
    }

    protected FocusListener createFocusListener() {
        return new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String textFieldValue = AbstractLookupBinding.this.getKeyComponentText();
                boolean empty = "".equals(textFieldValue.trim());
                Object ref = AbstractLookupBinding.this.getValue();
                if (AbstractLookupBinding.this.evaluateFocusLost(e)) {
                    if (AbstractLookupBinding.this.revertValueOnFocusLost()) {
                        if (empty) {
                            AbstractLookupBinding.this.getValueModel().setValue(null);
                        } else {
                            AbstractLookupBinding.this.valueModelChanged(AbstractLookupBinding.super.getValue());
                        }
                    } else if (empty && ref != null) {
                        AbstractLookupBinding.this.getValueModel().setValue(null);
                    } else if (!(empty || ref != null && textFieldValue.equals(AbstractLookupBinding.this.getObjectLabel(ref)))) {
                        AbstractLookupBinding.this.getValueModel().setValue(AbstractLookupBinding.this.createFilterFromString(textFieldValue));
                    }
                }
            }
        };
    }

    protected boolean evaluateFocusLost(FocusEvent e) {
        Component oppositeComponent = e.getOppositeComponent();
        return oppositeComponent != this.getDataEditorButton() && oppositeComponent != this.getKeyComponent();
    }

    @Override
    protected void readOnlyChanged() {
        if (this.getKeyComponent() instanceof JTextComponent) {
            ((JTextComponent)this.getKeyComponent()).setEditable(this.isEnabled() && !this.isReadOnly());
        }
        this.getDataEditorCommand().setEnabled(this.isEnabled() && !this.isReadOnly());
    }

    @Override
    protected void enabledChanged() {
        this.getKeyComponent().setEnabled(this.isEnabled());
        this.readOnlyChanged();
    }

    protected Object initializeDataEditor() {
        String textFieldValue = this.getKeyComponentText();
        Object ref = super.getValue();
        if (ref != null && textFieldValue.equals(this.getObjectLabel(ref))) {
            return this.getDataEditor().setSelectedSearch(ref);
        }
        return this.getDataEditor().setSelectedSearch(this.createFilterFromString(textFieldValue));
    }

    protected abstract Object createFilterFromString(String var1);

    protected AbstractButton getDataEditorButton() {
        if (this.dataEditorButton == null) {
            this.dataEditorButton = this.getDataEditorCommand().createButton();
            this.dataEditorButton.addFocusListener(this.createFocusListener());
        }
        return this.dataEditorButton;
    }

    protected final ActionCommand getDataEditorCommand() {
        if (this.dataEditorCommand == null) {
            this.dataEditorCommand = this.createDataEditorCommand();
        }
        return this.dataEditorCommand;
    }

    protected ActionCommand createDataEditorCommand() {
        ActionCommand selectDialogCommand = new ActionCommand(this.getSelectDialogCommandId()){
            private ApplicationDialog dataEditorDialog;

            protected void doExecuteCommand() {
                if (AbstractLookupBinding.this.propertyChangeMonitor.proceedOnChange()) {
                    if (this.dataEditorDialog == null) {
                        this.dataEditorDialog = new TitledWidgetApplicationDialog(AbstractLookupBinding.this.getDataEditor(), 3){

                            protected boolean onFinish() {
                                if (AbstractLookupBinding.this.getDataEditor().canClose()) {
                                    return AbstractLookupBinding.this.onFinish();
                                }
                                return false;
                            }

                            protected boolean onSelectNone() {
                                AbstractLookupBinding.this.getDataEditor().getTableWidget().unSelectAll();
                                return super.onSelectNone();
                            }

                            protected void onCancel() {
                                if (AbstractLookupBinding.this.getDataEditor().canClose()) {
                                    super.onCancel();
                                }
                            }
                        };
                        this.dataEditorDialog.setParentComponent(AbstractLookupBinding.this.getDataEditorButton());
                        AbstractLookupBinding.this.getDataEditor().setSelectMode(true);
                        RcpSupport.configure(this.dataEditorDialog, AbstractLookupBinding.this.getSelectDialogId());
                    }
                    if (this.getParameter(AbstractLookupBinding.NO_INITIALIZE_DATA_EDITOR) != ON) {
                        AbstractLookupBinding.this.initializeDataEditor();
                    }
                    if (AbstractLookupBinding.this.getDialogSize() != null) {
                        this.dataEditorDialog.getDialog().setMinimumSize(AbstractLookupBinding.this.getDialogSize());
                    }
                    this.dataEditorDialog.showDialog();
                }
            }
        };
        RcpSupport.configure(selectDialogCommand);
        return selectDialogCommand;
    }

    protected DefaultDataEditorWidget getDataEditor() {
        return this.dataEditor;
    }

    protected boolean onFinish() {
        this.setValue(this.getDataEditor().getSelectedRowObject(), false);
        return true;
    }

    private void setValue(Object value, boolean doLoadDetailedObject) {
        if (value != null && !this.loadDetailedObject) {
            value = this.getDataEditor().getDataProvider().getSimpleObject(value);
        } else if (value != null && doLoadDetailedObject) {
            value = this.getDataEditor().getDataProvider().getDetailObject(value, false);
        }
        this.getValueModel().setValue(value);
    }

    public void setDataEditorViewCommandId(String dataEditorViewCommandId) {
        this.dataEditorViewCommandId = dataEditorViewCommandId;
    }

    public String getDataEditorViewCommandId() {
        return this.dataEditorViewCommandId;
    }

    public void setEnableViewCommand(boolean enableViewCommand) {
        this.enableViewCommand = enableViewCommand;
    }

    public boolean isEnableViewCommand() {
        return this.enableViewCommand;
    }

    public boolean isLoadDetailedObject() {
        return this.loadDetailedObject;
    }

    public void setLoadDetailedObject(boolean loadDetailedObject) {
        this.loadDetailedObject = loadDetailedObject;
    }

    public void setFilter(Object filter) {
        this.filter = filter;
    }

    public Object getFilter() {
        return this.filter;
    }

    public Dimension getDialogSize() {
        return null;
    }

    protected static class TabKeyListener
    extends KeyAdapter {
        protected TabKeyListener() {
        }

        public void onTabKey(Component component) {
            component.transferFocus();
        }

        public void onShiftTabKey(Component component) {
            component.transferFocusBackward();
        }

        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\t' && !e.isShiftDown()) {
                this.onTabKey(e.getComponent());
            } else if (e.getKeyChar() == '\t' && e.isShiftDown()) {
                this.onShiftTabKey(e.getComponent());
            }
        }
    }

    private class ReferableDataEditorViewCommand
    extends ActionCommand {
        private Object selectedObject;

        public ReferableDataEditorViewCommand() {
            super("referableDataEditorViewCommand");
            RcpSupport.configure(this);
        }

        public void setSelectedObject(Object selectedObject) {
            this.selectedObject = selectedObject;
        }

        protected void doExecuteCommand() {
            Assert.notNull((Object)AbstractLookupBinding.this.dataEditorViewCommandId);
            DataEditorWidgetViewCommand command = (DataEditorWidgetViewCommand)RcpSupport.getCommand(AbstractLookupBinding.this.dataEditorViewCommandId);
            RcpSupport.executeViewDataEditorCommand(command, AbstractLookupBinding.this.filter, this.selectedObject);
        }
    }

    private static class PropertyChangeMonitor
    extends JComponent {
        private static final long serialVersionUID = -5117792596024956433L;

        private PropertyChangeMonitor() {
        }

        public boolean proceedOnChange() {
            boolean proceedNotVetoed = true;
            try {
                this.fireVetoableChange(AbstractLookupBinding.ON_ABOUT_TO_CHANGE, false, true);
            }
            catch (PropertyVetoException e) {
                proceedNotVetoed = false;
            }
            return proceedNotVetoed;
        }
    }
}

