/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing.text;

import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.springframework.richclient.form.binding.swing.text.DocumentFactory;

public class RegExDocumentFactory
implements DocumentFactory {
    private String characterPattern;
    private boolean convertToUppercase;

    public RegExDocumentFactory() {
        this(".");
    }

    public RegExDocumentFactory(String characterPattern) {
        this(characterPattern, false);
    }

    public RegExDocumentFactory(String characterPattern, boolean convertToUppercase) {
        this.characterPattern = characterPattern;
        this.convertToUppercase = convertToUppercase;
    }

    public String getCharacterPattern() {
        return this.characterPattern;
    }

    public void setCharacterPattern(String characterPattern) {
        this.characterPattern = characterPattern;
    }

    public boolean isConvertToUppercase() {
        return this.convertToUppercase;
    }

    public void setConvertToUppercase(boolean convertToUppercase) {
        this.convertToUppercase = convertToUppercase;
    }

    public Document createDocument() {
        return new RegExDocument(this.getCharacterPattern(), this.isConvertToUppercase());
    }

    private static class RegExDocument
    extends PlainDocument {
        private final Pattern pattern;
        private final boolean convertToUppercase;

        public RegExDocument(String stringPattern, boolean convertToUppercase) {
            this.pattern = Pattern.compile(stringPattern, 32);
            this.convertToUppercase = convertToUppercase;
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            char[] upper = str.toCharArray();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < upper.length; ++i) {
                char character = this.convertToUppercase ? Character.toUpperCase(upper[i]) : upper[i];
                if (!this.pattern.matcher(Character.toString(character)).find()) continue;
                builder.append(character);
            }
            super.insertString(offs, builder.toString(), a);
        }
    }
}

