/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing.text;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.text.DefaultFormatter;

public class TimeFormatter
extends DefaultFormatter {
    public static final char SEPARATOR = ':';
    public static final String SEPARATOR_STRING = ":";
    private DateFormat dateFormat = new SimpleDateFormat("H:mm");

    public TimeFormatter() {
        this.setAllowsInvalid(true);
        this.setCommitsOnValidEdit(false);
        this.setOverwriteMode(false);
        this.dateFormat.setLenient(false);
    }

    public Object stringToValue(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            return null;
        }
        int length = string.length();
        if (length == 1 && string.equals(SEPARATOR_STRING)) {
            return Calendar.getInstance().getTime();
        }
        if (string.indexOf(58) == -1 && length > 1) {
            string = string.charAt(length - 2) > '5' ? string.substring(0, length - 1) + SEPARATOR_STRING + string.substring(length - 1) : string.substring(0, length - 2) + SEPARATOR_STRING + string.substring(length - 2);
        }
        if (string.startsWith(Character.toString(':'))) {
            string = "0" + string;
        }
        return this.dateFormat.parse(string);
    }

    public String valueToString(Object value) throws ParseException {
        if (value != null) {
            return this.dateFormat.format(value);
        }
        return "";
    }
}

