/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.factory.ComponentFactory;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.BindingFactory;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.rules.constraint.Constraint;
import org.springframework.util.Assert;

public abstract class AbstractFormBuilder {
    private final BindingFactory bindingFactory;
    private ComponentFactory componentFactory;
    private FormComponentInterceptor interceptor;
    private FormComponentInterceptorFactory interceptorFactory;

    protected AbstractFormBuilder(BindingFactory bindingFactory) {
        Assert.notNull((Object)bindingFactory);
        this.bindingFactory = bindingFactory;
    }

    protected FormComponentInterceptor getFormComponentInterceptor() {
        if (this.interceptor == null) {
            if (this.interceptorFactory == null) {
                this.interceptorFactory = (FormComponentInterceptorFactory)ApplicationServicesLocator.services().getService(FormComponentInterceptorFactory.class);
            }
            this.interceptor = this.interceptorFactory.getInterceptor(this.getFormModel());
        }
        return this.interceptor;
    }

    public void setFormComponentInterceptorFactory(FormComponentInterceptorFactory interceptorFactory) {
        this.interceptorFactory = interceptorFactory;
        this.interceptor = null;
    }

    protected ComponentFactory getComponentFactory() {
        if (this.componentFactory == null) {
            this.componentFactory = (ComponentFactory)ApplicationServicesLocator.services().getService(ComponentFactory.class);
        }
        return this.componentFactory;
    }

    public void setComponentFactory(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    protected BindingFactory getBindingFactory() {
        return this.bindingFactory;
    }

    protected FormModel getFormModel() {
        return this.bindingFactory.getFormModel();
    }

    protected Binding createDefaultBinding(String fieldName) {
        return this.getBindingFactory().createBinding(fieldName);
    }

    protected Binding createBinding(String fieldName, JComponent component) {
        return this.getBindingFactory().bindControl(component, fieldName);
    }

    protected Binding createBinding(String fieldName, JComponent component, Map context) {
        return this.getBindingFactory().bindControl(component, fieldName, context);
    }

    protected JComponent createSelector(String fieldName, Constraint filter) {
        HashMap<String, Constraint> context = new HashMap<String, Constraint>();
        context.put("filter", filter);
        return this.getBindingFactory().createBinding(JComboBox.class, fieldName).getControl();
    }

    protected JComponent createScrollPane(String fieldName, JComponent component) {
        return this.getComponentFactory().createScrollPane(component);
    }

    protected JPasswordField createPasswordField(String fieldName) {
        return this.getComponentFactory().createPasswordField();
    }

    protected JComponent createTextArea(String fieldName) {
        return this.getComponentFactory().createTextArea(5, 40);
    }

    protected JLabel createLabelFor(String fieldName, JComponent component) {
        JLabel label = this.getComponentFactory().createLabel("");
        this.getFormModel().getFieldFace(fieldName).configure(label);
        label.setLabelFor(component);
        FormComponentInterceptor interceptor = this.getFormComponentInterceptor();
        if (interceptor != null) {
            interceptor.processLabel(fieldName, label);
        }
        return label;
    }
}

