/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder;

import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.BindingFactory;
import org.springframework.richclient.form.builder.AbstractFormBuilder;
import org.springframework.richclient.layout.TableLayoutBuilder;
import org.springframework.rules.constraint.Constraint;
import org.springframework.util.Assert;

public class TableFormBuilder
extends AbstractFormBuilder {
    private static final String VALIGN_TOP = "valign=top";
    private TableLayoutBuilder builder;
    private String labelAttributes = "colGrId=label colSpec=left:pref";

    public TableFormBuilder(BindingFactory bindingFactory) {
        this(bindingFactory, null);
    }

    public TableFormBuilder(BindingFactory bindingFactory, TableLayoutBuilder tableLayoutBuilder) {
        super(bindingFactory);
        this.builder = tableLayoutBuilder;
    }

    public void row() {
        this.getLayoutBuilder().relatedGapRow();
    }

    public JComponent[] add(String fieldName) {
        return this.add(fieldName, "");
    }

    public JComponent[] add(Binding binding) {
        return this.add(binding, "");
    }

    public JComponent[] add(String fieldName, String attributes) {
        return this.addBinding(this.createDefaultBinding(fieldName), attributes, this.getLabelAttributes());
    }

    public JComponent[] add(Binding binding, String attributes) {
        return this.addBinding(binding, attributes, this.getLabelAttributes());
    }

    public JComponent[] add(String fieldName, JComponent component) {
        return this.add(fieldName, component, "");
    }

    public JComponent[] add(String fieldName, JComponent component, String attributes) {
        return this.addBinding(this.createBinding(fieldName, component), attributes, this.getLabelAttributes());
    }

    public JComponent[] addSelector(String fieldName, Constraint filter) {
        return this.addSelector(fieldName, filter, "");
    }

    public JComponent[] addSelector(String fieldName, Constraint filter, String attributes) {
        HashMap<String, Constraint> context = new HashMap<String, Constraint>();
        context.put("filter", filter);
        return this.addBinding(this.getBindingFactory().createBinding(JComboBox.class, fieldName), attributes, this.getLabelAttributes());
    }

    public JComponent[] addPasswordField(String fieldName) {
        return this.addPasswordField(fieldName, "");
    }

    public JComponent[] addPasswordField(String fieldName, String attributes) {
        return this.addBinding(this.createBinding(fieldName, this.createPasswordField(fieldName)), attributes, this.getLabelAttributes());
    }

    public JComponent[] addTextArea(String fieldName) {
        return this.addTextArea(fieldName, "");
    }

    public JComponent[] addTextArea(String fieldName, String attributes) {
        JComponent textArea = this.createTextArea(fieldName);
        String labelAttributes = this.getLabelAttributes();
        if (labelAttributes == null) {
            labelAttributes = VALIGN_TOP;
        } else if (!labelAttributes.contains("valign")) {
            labelAttributes = labelAttributes + " valign=top";
        }
        return this.addBinding(this.createBinding(fieldName, textArea), new JScrollPane(textArea), attributes, labelAttributes);
    }

    public JComponent[] addInScrollPane(String fieldName) {
        return this.addInScrollPane(fieldName, "");
    }

    public JComponent[] addInScrollPane(String fieldName, String attributes) {
        return this.addInScrollPane(this.createDefaultBinding(fieldName), attributes);
    }

    public JComponent[] addInScrollPane(Binding binding) {
        return this.addInScrollPane(binding, "");
    }

    public JComponent[] addInScrollPane(Binding binding, String attributes) {
        Assert.isTrue((this.getFormModel() == binding.getFormModel() ? 1 : 0) != 0, (String)"Binding's form model must match FormBuilder's form model");
        return this.add(binding.getProperty(), this.createScrollPane(binding.getProperty(), binding.getControl()), attributes);
    }

    public JComponent addSeparator(String text) {
        return this.addSeparator(text, "");
    }

    public JComponent addSeparator(String text, String attributes) {
        JComponent separator = this.getComponentFactory().createLabeledSeparator(text);
        this.getLayoutBuilder().cell(separator, attributes);
        return separator;
    }

    public TableLayoutBuilder getLayoutBuilder() {
        if (this.builder == null) {
            this.builder = new TableLayoutBuilder(this.getComponentFactory().createPanel());
        }
        return this.builder;
    }

    public JComponent getForm() {
        this.getBindingFactory().getFormModel().revert();
        return this.getLayoutBuilder().getPanel();
    }

    public String getLabelAttributes() {
        return this.labelAttributes;
    }

    public void setLabelAttributes(String labelAttributes) {
        this.labelAttributes = labelAttributes;
    }

    public JComponent[] addBinding(Binding binding, String attributes, String labelAttributes) {
        return this.addBinding(binding, binding.getControl(), attributes, labelAttributes);
    }

    public JComponent[] addBinding(Binding binding, JComponent wrappedControl, String attributes) {
        return this.addBinding(binding, wrappedControl, attributes, this.getLabelAttributes());
    }

    public JComponent[] addBinding(Binding binding, JComponent wrappedComponent, String attributes, String labelAttributes) {
        TableLayoutBuilder layoutBuilder;
        Assert.notNull((Object)binding, (String)"binding is null");
        Assert.isTrue((this.getFormModel() == binding.getFormModel() ? 1 : 0) != 0, (String)"Binding's form model must match FormBuilder's form model");
        JComponent component = binding.getControl();
        JLabel label = this.createLabelFor(binding.getProperty(), component);
        if (wrappedComponent == null) {
            wrappedComponent = component;
        }
        if (!(layoutBuilder = this.getLayoutBuilder()).hasGapToLeft()) {
            layoutBuilder.gapCol();
        }
        layoutBuilder.cell(label, labelAttributes);
        layoutBuilder.labelGapCol();
        layoutBuilder.cell(wrappedComponent, attributes);
        return new JComponent[]{label, component, wrappedComponent};
    }
}

