/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder.support;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXDatePicker;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.form.HasValidationComponent;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.richclient.form.builder.support.ValidationInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorValidationInterceptorFactory
implements FormComponentInterceptorFactory {
    private static final Color DEFAULT_ERROR_COLOR = new Color(255, 220, 220);
    private static final Color DEFAULT_WARNING_COLOR = new Color(255, 255, 160);
    private Map<Severity, Color> colorMap = new HashMap<Severity, Color>();

    public ColorValidationInterceptorFactory() {
        this.colorMap.put(Severity.ERROR, DEFAULT_ERROR_COLOR);
        this.colorMap.put(Severity.WARNING, DEFAULT_WARNING_COLOR);
    }

    public void setColorMap(Map<Severity, Color> colorMap) {
        this.colorMap = colorMap;
    }

    public void setErrorColor(Color color) {
        this.colorMap.put(Severity.ERROR, color);
    }

    public void setWarningColor(Color color) {
        this.colorMap.put(Severity.WARNING, color);
    }

    @Override
    public FormComponentInterceptor getInterceptor(FormModel formModel) {
        return new ColorValidationInterceptor(formModel);
    }

    private class ColorChanger
    implements Messagable {
        private JTextComponent component;

        public ColorChanger(JTextComponent component) {
            this.component = component;
        }

        public void setMessage(Message message) {
            Color colorToSet;
            Color color = colorToSet = message == null ? null : (Color)ColorValidationInterceptorFactory.this.colorMap.get((Object)message.getSeverity());
            if (colorToSet != null) {
                this.component.setBackground(colorToSet);
            } else if (!this.component.isEnabled()) {
                this.component.setBackground(UIManager.getColor("TextField.disabledBackground"));
            } else if (!this.component.isEditable()) {
                this.component.setBackground(UIManager.getColor("TextField.inactiveBackground"));
            } else {
                this.component.setBackground(UIManager.getColor("TextField.background"));
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        }
    }

    private class ColorValidationInterceptor
    extends ValidationInterceptor {
        public ColorValidationInterceptor(FormModel formModel) {
            super(formModel);
        }

        public void processComponent(String propertyName, JComponent component) {
            JComponent innerComponent = this.getInnerComponent(component);
            if (innerComponent instanceof JTextComponent) {
                ColorChanger colorChanger = new ColorChanger((JTextComponent)innerComponent);
                this.registerMessageReceiver(propertyName, colorChanger);
            }
        }

        protected JComponent getInnerComponent(JComponent component) {
            if (component instanceof JXDatePicker) {
                return ((JXDatePicker)component).getEditor();
            }
            if (component instanceof HasValidationComponent) {
                return ((HasValidationComponent)((Object)component)).getValidationComponent();
            }
            return super.getInnerComponent(component);
        }
    }
}

