/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.components.MayHaveMessagableTab;
import org.springframework.richclient.components.MessagableTab;
import org.springframework.richclient.core.Guarded;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.dialog.DefaultMessageAreaModel;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.form.HasValidationComponent;
import org.springframework.richclient.form.builder.FormComponentInterceptor;
import org.springframework.richclient.form.builder.FormComponentInterceptorFactory;
import org.springframework.richclient.form.builder.support.ValidationInterceptor;
import org.springframework.richclient.util.OverlayHelper;
import org.springframework.richclient.util.RcpSupport;

public class OverlayValidationInterceptorFactory
implements FormComponentInterceptorFactory {
    public FormComponentInterceptor getInterceptor(FormModel formModel) {
        return new OverlayValidationInterceptor(formModel);
    }

    private static class ErrorReportingOverlay
    extends JLabel
    implements Messagable,
    Guarded,
    MayHaveMessagableTab {
        private DefaultMessageAreaModel messageBuffer = new DefaultMessageAreaModel(this);
        private MessagableTab messagableTab = null;
        private int tabIndex = 0;

        private ErrorReportingOverlay() {
        }

        public boolean isEnabled() {
            return true;
        }

        public void setEnabled(boolean enabled) {
            this.setVisible(!enabled);
        }

        public void setMessagableTab(MessagableTab messagableTab, int tabIndex) {
            this.messagableTab = messagableTab;
            this.tabIndex = tabIndex;
        }

        public void setMessage(Message message) {
            if (this.messagableTab != null) {
                this.messagableTab.setMessage(this, message, this.tabIndex);
            }
            this.messageBuffer.setMessage(message);
            message = this.messageBuffer.getMessage();
            this.setToolTipText(message.getMessage());
            Severity severity = message.getSeverity();
            if (severity != null) {
                this.setIcon(RcpSupport.getIcon("severity." + severity.getLabel() + ".overlay"));
            } else {
                this.setIcon(null);
            }
        }
    }

    public class OverlayValidationInterceptor
    extends ValidationInterceptor {
        public OverlayValidationInterceptor(FormModel formModel) {
            super(formModel);
        }

        public void processComponent(String propertyName, final JComponent component) {
            final ErrorReportingOverlay overlay = new ErrorReportingOverlay();
            this.registerGuarded(propertyName, overlay);
            this.registerMessageReceiver(propertyName, overlay);
            if (component.getParent() == null) {
                PropertyChangeListener waitUntilHasParentListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent e) {
                        if (component.getParent() != null) {
                            component.removePropertyChangeListener("ancestor", this);
                            OverlayValidationInterceptor.this.attachOverlay(overlay, component);
                        }
                    }
                };
                component.addPropertyChangeListener("ancestor", waitUntilHasParentListener);
            } else {
                this.attachOverlay(overlay, component);
            }
        }

        private void attachOverlay(ErrorReportingOverlay overlay, JComponent component) {
            JComponent componentToOverlay = component instanceof HasValidationComponent ? ((HasValidationComponent)((Object)component)).getValidationComponent() : (this.hasParentScrollPane(component) ? this.getParentScrollPane(component) : component);
            int yOffset = componentToOverlay.getPreferredSize().height;
            OverlayHelper.attachOverlay(overlay, componentToOverlay, 8, 0, Math.min(yOffset, new JTextField().getPreferredSize().height));
        }

        private JScrollPane getParentScrollPane(JComponent component) {
            return (JScrollPane)component.getParent().getParent();
        }

        private boolean hasParentScrollPane(JComponent component) {
            return component.getParent() != null && component.getParent() instanceof JViewport && component.getParent().getParent() instanceof JScrollPane;
        }
    }
}

