/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder.support;

import java.util.Locale;
import javax.swing.text.JTextComponent;
import org.jdesktop.xswingx.PromptSupport;
import org.springframework.binding.form.FormModel;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.richclient.text.TextComponentInterceptor;
import org.springframework.util.StringUtils;

public class PromptTextFieldFormComponentInterceptor
extends TextComponentInterceptor {
    private MessageSource messageSource;
    private FormModel formModel;
    private static final String DEFAULT_PROMPT_KEY = "prompt";
    private String promptKey;

    public String getPromptKey() {
        if (this.promptKey == null) {
            return DEFAULT_PROMPT_KEY;
        }
        return this.promptKey;
    }

    public void setPromptKey(String promptKey) {
        this.promptKey = promptKey;
    }

    public PromptTextFieldFormComponentInterceptor(FormModel formModel, MessageSource messageSource) {
        this.formModel = formModel;
        this.messageSource = messageSource;
    }

    protected void processComponent(String propertyName, JTextComponent textComponent) {
        String prompt = this.messageSource.getMessage((MessageSourceResolvable)new DefaultMessageSourceResolvable(this.getMessageKeys(this.formModel, propertyName), ""), Locale.getDefault());
        if (StringUtils.hasText((String)prompt)) {
            PromptSupport.setFontStyle((Integer)2, (JTextComponent)textComponent);
            PromptSupport.setPrompt((String)prompt, (JTextComponent)textComponent);
        }
    }

    protected String[] getMessageKeys(FormModel formModel, String propertyName) {
        return new String[]{formModel.getId() + "." + propertyName + "." + this.getPromptKey(), propertyName + "." + this.getPromptKey()};
    }
}

