/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class AwtImageResource
extends AbstractResource
implements ImageObserver {
    private Resource wrappedResource;
    private boolean imageLoaded;
    private boolean imageError;
    public static final String RESOURCE_PREFIX = "image:";

    public AwtImageResource(Resource resource) {
        Assert.notNull((Object)resource);
        if (resource instanceof AwtImageResource) {
            throw new IllegalArgumentException("Wrapping another AwtImageResource instance is illegal.");
        }
        this.wrappedResource = resource;
    }

    public String getDescription() {
        return this.wrappedResource.getDescription();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.wrappedResource.createRelative(relativePath);
    }

    public boolean exists() {
        return this.wrappedResource.exists();
    }

    public boolean isOpen() {
        return this.wrappedResource.isOpen();
    }

    public URL getURL() throws IOException {
        return this.wrappedResource.getURL();
    }

    public File getFile() throws IOException {
        return this.wrappedResource.getFile();
    }

    public String getFilename() throws IllegalStateException {
        return this.wrappedResource.getFilename();
    }

    public InputStream getInputStream() throws IOException {
        return this.wrappedResource.getInputStream();
    }

    public Image getImage() throws IOException {
        return this.loadImage(this.getInputStream());
    }

    private synchronized Image loadImage(InputStream stream) throws IOException {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        byte[] data = FileCopyUtils.copyToByteArray((InputStream)stream);
        Image image = toolkit.createImage(data);
        this.imageLoaded = false;
        this.imageError = false;
        toolkit.prepareImage(image, -1, -1, this);
        while (!this.imageLoaded && !this.imageError) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        if (this.imageError) {
            throw new IOException("Error preparing image from resource.");
        }
        return image;
    }

    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if ((infoflags & 0x30) != 0) {
            this.imageLoaded = true;
            this.notifyAll();
        } else if ((infoflags & 0x40) != 0) {
            this.imageError = true;
            this.notifyAll();
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AwtImageResource)) {
            return false;
        }
        AwtImageResource r = (AwtImageResource)o;
        return this.wrappedResource.equals(r.wrappedResource);
    }

    public int hashCode() {
        return this.wrappedResource.hashCode();
    }
}

