/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.image;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.image.AwtImageResource;
import org.springframework.richclient.image.ImageSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Handler
extends URLStreamHandler {
    private static final Log logger = LogFactory.getLog(Handler.class);
    private static ImageSource urlHandlerImageSource;

    public static void installImageUrlHandler(ImageSource urlHandlerImageSource) {
        Assert.notNull((Object)urlHandlerImageSource);
        Handler.urlHandlerImageSource = urlHandlerImageSource;
        try {
            String packagePrefixList = System.getProperty("java.protocol.handler.pkgs");
            String newPackagePrefixList = null;
            String orgSpringFrameworkRichclientString = "org.springframework.richclient";
            if (packagePrefixList == null || packagePrefixList.equals("")) {
                newPackagePrefixList = orgSpringFrameworkRichclientString;
            } else if (("|" + packagePrefixList + "|").indexOf("|" + orgSpringFrameworkRichclientString + "|") < 0) {
                newPackagePrefixList = packagePrefixList + "|" + orgSpringFrameworkRichclientString;
            }
            if (newPackagePrefixList != null) {
                System.setProperty("java.protocol.handler.pkgs", newPackagePrefixList);
            }
        }
        catch (SecurityException e) {
            logger.warn((Object)"Unable to install image URL handler", (Throwable)e);
            Handler.urlHandlerImageSource = null;
        }
    }

    protected URLConnection openConnection(URL url) throws IOException {
        if (!StringUtils.hasText((String)url.getPath())) {
            throw new MalformedURLException("must provide an image key.");
        }
        if (StringUtils.hasText((String)url.getHost())) {
            throw new MalformedURLException("host part should be empty.");
        }
        if (url.getPort() != -1) {
            throw new MalformedURLException("port part should be empty.");
        }
        if (StringUtils.hasText((String)url.getQuery())) {
            throw new MalformedURLException("query part should be empty.");
        }
        if (StringUtils.hasText((String)url.getRef())) {
            throw new MalformedURLException("ref part should be empty.");
        }
        if (StringUtils.hasText((String)url.getUserInfo())) {
            throw new MalformedURLException("user info part should be empty.");
        }
        urlHandlerImageSource.getImage(url.getPath());
        AwtImageResource image = urlHandlerImageSource.getImageResource(url.getPath());
        if (image != null) {
            return image.getURL().openConnection();
        }
        throw new IOException("null image returned for key [" + url.getFile() + "].");
    }
}

