/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.jnlp;

import java.util.Properties;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class JnlpPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    public static final String WEB_APP_CONTEXT_URL_PLACEHOLDER = "jnlp.webAppContextUrl";
    private boolean contextOverride = false;
    private String fallBackWebAppContextUrl = "http://localhost:8080/";
    private String jnlpRelativeDirectoryPathFromWebAppContext = "/";

    public void setContextOverride(boolean contextOverride) {
        this.contextOverride = contextOverride;
    }

    public void setFallBackWebAppContextUrl(String fallBackWebAppContextUrl) {
        this.fallBackWebAppContextUrl = fallBackWebAppContextUrl;
    }

    public void setJnlpRelativeDirectoryPathFromWebAppContext(String jnlpRelativeDirectoryPathFromWebAppContext) {
        this.jnlpRelativeDirectoryPathFromWebAppContext = jnlpRelativeDirectoryPathFromWebAppContext;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        String value = null;
        if (this.contextOverride) {
            value = this.resolvePlaceholder(placeholder);
        }
        if (value == null) {
            value = super.resolvePlaceholder(placeholder, props);
        }
        if (value == null) {
            value = this.resolvePlaceholder(placeholder);
        }
        return value;
    }

    protected String resolvePlaceholder(String placeholder) {
        String value = null;
        if (placeholder.equals(WEB_APP_CONTEXT_URL_PLACEHOLDER)) {
            value = this.getWebAppContextUrl();
        }
        return value;
    }

    public String getWebAppContextUrl() {
        String webAppContextUrl;
        try {
            BasicService basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            String codeBase = basicService.getCodeBase().toExternalForm();
            if (!codeBase.endsWith("/")) {
                codeBase = codeBase + "/";
            }
            int webAppContextUrlLength = codeBase.lastIndexOf(this.jnlpRelativeDirectoryPathFromWebAppContext);
            webAppContextUrl = codeBase.substring(0, webAppContextUrlLength + 1);
        }
        catch (UnavailableServiceException e) {
            webAppContextUrl = this.fallBackWebAppContextUrl;
        }
        return webAppContextUrl;
    }
}

