/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public abstract class AbstractFilteredListModel
extends AbstractListModel
implements ListDataListener {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected ListModel filteredModel;

    public AbstractFilteredListModel(ListModel model) {
        Assert.notNull((Object)model);
        this.filteredModel = model;
        this.filteredModel.addListDataListener(this);
    }

    public ListModel getFilteredModel() {
        return this.filteredModel;
    }

    public void setFilteredModel(ListModel model) {
        Assert.notNull((Object)model);
        this.filteredModel.removeListDataListener(this);
        this.filteredModel = model;
        this.filteredModel.addListDataListener(this);
        this.fireContentsChanged(this, -1, -1);
    }

    public Object getElementAt(int index) {
        return this.filteredModel.getElementAt(this.getElementIndex(index));
    }

    public int getSize() {
        return this.filteredModel.getSize();
    }

    public void contentsChanged(ListDataEvent e) {
        this.fireContentsChanged(e.getSource(), e.getIndex0(), e.getIndex1());
    }

    public void intervalAdded(ListDataEvent e) {
        this.fireIntervalAdded(e.getSource(), e.getIndex0(), e.getIndex1());
    }

    public void intervalRemoved(ListDataEvent e) {
        this.fireIntervalRemoved(e.getSource(), e.getIndex0(), e.getIndex1());
    }

    public int getElementIndex(int filteredIndex) {
        return filteredIndex;
    }
}

